/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmfeatures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/westnordost/osmfeatures/StartsWithStringTree;", "", "strings", "", "", "maxDepth", "", "minContainerSize", "(Ljava/util/Collection;II)V", "root", "Lde/westnordost/osmfeatures/StartsWithStringTree$Node;", "getAll", "", "startsWith", "Companion", "Node", "osmfeatures"})
public final class StartsWithStringTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Node root;

    public StartsWithStringTree(@NotNull Collection<String> strings, int maxDepth, int minContainerSize) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        this.root = StartsWithStringTree.Companion.buildTree(strings, 0, RangesKt.coerceAtLeast((int)maxDepth, (int)0), RangesKt.coerceAtLeast((int)minContainerSize, (int)1));
    }

    public /* synthetic */ StartsWithStringTree(Collection collection, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 16;
        }
        if ((n3 & 4) != 0) {
            n2 = 16;
        }
        this(collection, n, n2);
    }

    @NotNull
    public final List<String> getAll(@NotNull String startsWith) {
        Intrinsics.checkNotNullParameter((Object)startsWith, (String)"startsWith");
        return this.root.getAll(startsWith, 0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J.\u0010\f\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\r*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lde/westnordost/osmfeatures/StartsWithStringTree$Companion;", "", "()V", "buildTree", "Lde/westnordost/osmfeatures/StartsWithStringTree$Node;", "strings", "", "", "currentDepth", "", "maxDepth", "minContainerSize", "groupedByNthCharacter", "", "", "nth", "osmfeatures"})
    public static final class Companion {
        private Companion() {
        }

        private final Node buildTree(Collection<String> strings, int currentDepth, int maxDepth, int minContainerSize) {
            if (currentDepth == maxDepth || strings.size() < minContainerSize) {
                return new Node(MapsKt.emptyMap(), strings);
            }
            Map<Character, Collection<String>> stringsByCharacter = this.groupedByNthCharacter(strings, currentDepth);
            HashMap children = new HashMap(stringsByCharacter.size());
            for (Map.Entry<Character, Collection<String>> entry : stringsByCharacter.entrySet()) {
                Character c = entry.getKey();
                Collection<String> stringsForChar = entry.getValue();
                Character c2 = c;
                if (c2 == null) {
                    continue;
                }
                char c3 = c2.charValue();
                Node child = this.buildTree(stringsForChar, currentDepth + 1, maxDepth, minContainerSize);
                Character c4 = Character.valueOf(c3);
                ((Map)children).put(c4, child);
            }
            Collection collection = stringsByCharacter.get(null);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            Collection remainingStrings = collection;
            Map compactChildren = children.isEmpty() ? MapsKt.emptyMap() : (Map)children;
            return new Node(compactChildren, remainingStrings);
        }

        private final Map<Character, Collection<String>> groupedByNthCharacter(Collection<String> $this$groupedByNthCharacter, int nth) {
            HashMap result = new HashMap();
            for (String string : $this$groupedByNthCharacter) {
                Character c;
                Character c2 = c = string.length() > nth ? Character.valueOf(string.charAt(nth)) : null;
                if (!result.containsKey(c)) {
                    ((Map)result).put(c, new ArrayList());
                }
                Collection collection = (Collection)result.get(c);
                if (collection == null) continue;
                collection.add(string);
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00000\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lde/westnordost/osmfeatures/StartsWithStringTree$Node;", "", "children", "", "", "strings", "", "", "(Ljava/util/Map;Ljava/util/Collection;)V", "getChildren", "()Ljava/util/Map;", "getStrings", "()Ljava/util/Collection;", "getAll", "", "startsWith", "offset", "", "osmfeatures"})
    private static final class Node {
        @NotNull
        private final Map<Character, Node> children;
        @NotNull
        private final Collection<String> strings;

        public Node(@NotNull Map<Character, Node> children, @NotNull Collection<String> strings) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter(strings, (String)"strings");
            this.children = children;
            this.strings = strings;
        }

        @NotNull
        public final Map<Character, Node> getChildren() {
            return this.children;
        }

        @NotNull
        public final Collection<String> getStrings() {
            return this.strings;
        }

        @NotNull
        public final List<String> getAll(@NotNull String startsWith, int offset) {
            Intrinsics.checkNotNullParameter((Object)startsWith, (String)"startsWith");
            if (((CharSequence)startsWith).length() == 0) {
                return CollectionsKt.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            for (Map.Entry<Character, Node> entry : this.children.entrySet()) {
                char c = entry.getKey().charValue();
                Node childNode = entry.getValue();
                if (startsWith.length() > offset && c != startsWith.charAt(offset)) continue;
                result.addAll((Collection)childNode.getAll(startsWith, offset + 1));
            }
            for (String string : this.strings) {
                if (!StringsKt.startsWith$default((String)string, (String)startsWith, (boolean)false, (int)2, null)) continue;
                result.add(string);
            }
            return result;
        }
    }
}

