/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmfeatures;

import de.westnordost.osmfeatures.Feature;
import de.westnordost.osmfeatures.FeatureDictionaryKt;
import de.westnordost.osmfeatures.FeatureTagsIndex;
import de.westnordost.osmfeatures.FeatureTermIndex;
import de.westnordost.osmfeatures.FileSystemAccess;
import de.westnordost.osmfeatures.GeometryType;
import de.westnordost.osmfeatures.IDBrandPresetsFeatureCollection;
import de.westnordost.osmfeatures.IDLocalizedFeatureCollection;
import de.westnordost.osmfeatures.Language_jvmKt;
import de.westnordost.osmfeatures.LocalizedFeatureCollection;
import de.westnordost.osmfeatures.PerCountryFeatureCollection;
import de.westnordost.osmfeatures.StringUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.io.files.FileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 <2\u00020\u0001:\u00049:;<B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000bJ0\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0016\u001a\u00020\u000b2\u0012\b\u0002\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u000bJ\u001e\u0010\u001b\u001a\u00060\u001cR\u00020\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001eJ]\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\n2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001e2\u0012\b\u0002\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u00060&R\u00020\u00002\u0006\u0010'\u001a\u00020\u000bJQ\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180)2\u0006\u0010*\u001a\u00020\u000b2\u0012\b\u0002\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010+J\u0018\u0010,\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u0010-\u001a\u00020\u000f2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u0010.\u001a\u00020\r2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u0010/\u001a\u00020\r2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u00100\u001a\u00020\r2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u00101\u001a\u00020\r2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u00102\u001a\u00020\r2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u00103\u001a\u00020\r2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u00104\u001a\u00020\r2\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u00106\u001a\u00020\r2\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u00107\u001a\u00020\u000f2\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002J\u0018\u00108\u001a\u00020\u000f2\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u001c\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u001c\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u001c\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u001c\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0013\u001a\u001c\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lde/westnordost/osmfeatures/FeatureDictionary;", "", "featureCollection", "Lde/westnordost/osmfeatures/LocalizedFeatureCollection;", "brandFeatureCollection", "Lde/westnordost/osmfeatures/PerCountryFeatureCollection;", "<init>", "(Lde/westnordost/osmfeatures/LocalizedFeatureCollection;Lde/westnordost/osmfeatures/PerCountryFeatureCollection;)V", "brandNamesIndexes", "Ljava/util/HashMap;", "", "", "Lkotlin/Lazy;", "Lde/westnordost/osmfeatures/FeatureTermIndex;", "brandTagsIndexes", "Lde/westnordost/osmfeatures/FeatureTagsIndex;", "tagsIndexes", "namesIndexes", "termsIndexes", "tagValuesIndexes", "byId", "Lde/westnordost/osmfeatures/FeatureDictionary$QueryByIdBuilder;", "id", "getById", "Lde/westnordost/osmfeatures/Feature;", "languages", "country", "byTags", "Lde/westnordost/osmfeatures/FeatureDictionary$QueryByTagBuilder;", "tags", "", "getByTags", "geometry", "Lde/westnordost/osmfeatures/GeometryType;", "isSuggestion", "", "(Ljava/util/Map;Ljava/util/List;Ljava/lang/String;Lde/westnordost/osmfeatures/GeometryType;Ljava/lang/Boolean;)Ljava/util/List;", "byTerm", "Lde/westnordost/osmfeatures/FeatureDictionary$QueryByTermBuilder;", "term", "getByTerm", "Lkotlin/sequences/Sequence;", "search", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lde/westnordost/osmfeatures/GeometryType;Ljava/lang/Boolean;)Lkotlin/sequences/Sequence;", "getTagsIndex", "createTagsIndex", "getNamesIndex", "createNamesIndex", "getTermsIndex", "createTermsIndex", "getTagValuesIndex", "createTagValuesIndex", "getBrandNamesIndex", "countryCodes", "createBrandNamesIndex", "getBrandTagsIndex", "createBrandTagsIndex", "QueryByIdBuilder", "QueryByTagBuilder", "QueryByTermBuilder", "Companion", "osmfeatures"})
@SourceDebugExtension(value={"SMAP\nFeatureDictionary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureDictionary.kt\nde/westnordost/osmfeatures/FeatureDictionary\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,483:1\n381#2,7:484\n381#2,7:491\n381#2,7:498\n381#2,7:505\n381#2,7:512\n381#2,7:519\n1782#3,4:526\n1782#3,4:530\n1755#3,3:534\n1755#3,3:537\n1755#3,3:540\n1755#3,3:543\n1755#3,3:546\n1755#3,3:549\n774#3:552\n865#3,2:553\n*S KotlinDebug\n*F\n+ 1 FeatureDictionary.kt\nde/westnordost/osmfeatures/FeatureDictionary\n*L\n291#1:484,7\n298#1:491,7\n307#1:498,7\n316#1:505,7\n329#1:512,7\n342#1:519,7\n157#1:526,4\n158#1:530,4\n223#1:534,3\n224#1:537,3\n230#1:540,3\n231#1:543,3\n237#1:546,3\n238#1:549,3\n323#1:552\n323#1:553,2\n*E\n"})
public final class FeatureDictionary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalizedFeatureCollection featureCollection;
    @Nullable
    private final PerCountryFeatureCollection brandFeatureCollection;
    @NotNull
    private final HashMap<List<String>, Lazy<FeatureTermIndex>> brandNamesIndexes;
    @NotNull
    private final HashMap<List<String>, Lazy<FeatureTagsIndex>> brandTagsIndexes;
    @NotNull
    private final HashMap<List<String>, Lazy<FeatureTagsIndex>> tagsIndexes;
    @NotNull
    private final HashMap<List<String>, Lazy<FeatureTermIndex>> namesIndexes;
    @NotNull
    private final HashMap<List<String>, Lazy<FeatureTermIndex>> termsIndexes;
    @NotNull
    private final HashMap<List<String>, Lazy<FeatureTermIndex>> tagValuesIndexes;

    public FeatureDictionary(@NotNull LocalizedFeatureCollection featureCollection, @Nullable PerCountryFeatureCollection brandFeatureCollection) {
        Intrinsics.checkNotNullParameter((Object)featureCollection, (String)"featureCollection");
        this.featureCollection = featureCollection;
        this.brandFeatureCollection = brandFeatureCollection;
        this.brandNamesIndexes = new HashMap();
        this.brandTagsIndexes = new HashMap();
        this.tagsIndexes = new HashMap();
        this.namesIndexes = new HashMap();
        this.termsIndexes = new HashMap();
        this.tagValuesIndexes = new HashMap();
        Object[] objectArray = new String[]{Language_jvmKt.defaultLanguage(), null};
        this.getTagsIndex(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{Language_jvmKt.defaultLanguage(), null};
        this.getNamesIndex(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{Language_jvmKt.defaultLanguage(), null};
        this.getTermsIndex(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final QueryByIdBuilder byId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new QueryByIdBuilder(id);
    }

    @Nullable
    public final Feature getById(@NotNull String id, @Nullable List<String> languages, @Nullable String country) {
        Feature feature;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List list = languages;
        if (list == null) {
            Object[] objectArray = new String[]{Language_jvmKt.defaultLanguage(), null};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        if ((feature = this.featureCollection.get(id, list)) == null) {
            PerCountryFeatureCollection perCountryFeatureCollection = this.brandFeatureCollection;
            feature = perCountryFeatureCollection != null ? perCountryFeatureCollection.get(id, FeatureDictionaryKt.access$dissectCountryCode(country)) : null;
        }
        return feature;
    }

    public static /* synthetic */ Feature getById$default(FeatureDictionary featureDictionary, String string, List list, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return featureDictionary.getById(string, list, string2);
    }

    @NotNull
    public final QueryByTagBuilder byTags(@NotNull Map<String, String> tags) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        return new QueryByTagBuilder(tags);
    }

    @NotNull
    public final List<Feature> getByTags(@NotNull Map<String, String> tags, @Nullable List<String> languages, @Nullable String country, @Nullable GeometryType geometry, @Nullable Boolean isSuggestion) {
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        if (tags.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List list = languages;
        if (list == null) {
            Object[] objectArray = new String[]{Language_jvmKt.defaultLanguage(), null};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List languagesOrDefault = list;
        List foundFeatures = new ArrayList();
        if (isSuggestion == null || !isSuggestion.booleanValue()) {
            foundFeatures.addAll((Collection)this.getTagsIndex(languagesOrDefault).getAll(tags));
        }
        if (isSuggestion == null || isSuggestion.booleanValue()) {
            List countryCodes = FeatureDictionaryKt.access$dissectCountryCode(country);
            foundFeatures.addAll((Collection)this.getBrandTagsIndex(countryCodes).getAll(tags));
        }
        CollectionsKt.removeAll((List)foundFeatures, arg_0 -> FeatureDictionary.getByTags$lambda$0(geometry, country, arg_0));
        if (foundFeatures.size() > 1) {
            HashSet removeIds = new HashSet();
            for (Feature feature : foundFeatures) {
                CollectionsKt.addAll((Collection)removeIds, (Sequence)FeatureDictionaryKt.access$getParentCategoryIds(feature.getId()));
            }
            if (!((Collection)removeIds).isEmpty()) {
                CollectionsKt.removeAll((List)foundFeatures, arg_0 -> FeatureDictionary.getByTags$lambda$1(removeIds, arg_0));
            }
        }
        return CollectionsKt.sortedWith((Iterable)foundFeatures, (arg_0, arg_1) -> FeatureDictionary.getByTags$lambda$4(languagesOrDefault, tags, arg_0, arg_1));
    }

    public static /* synthetic */ List getByTags$default(FeatureDictionary featureDictionary, Map map, List list, String string, GeometryType geometryType, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            geometryType = null;
        }
        if ((n & 0x10) != 0) {
            bl = null;
        }
        return featureDictionary.getByTags(map, list, string, geometryType, bl);
    }

    @NotNull
    public final QueryByTermBuilder byTerm(@NotNull String term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        return new QueryByTermBuilder(term);
    }

    @NotNull
    public final Sequence<Feature> getByTerm(@NotNull String search, @Nullable List<String> languages, @Nullable String country, @Nullable GeometryType geometry, @Nullable Boolean isSuggestion) {
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        String canonicalSearch = StringUtilsKt.canonicalize(search);
        List list = languages;
        if (list == null) {
            Object[] objectArray = new String[]{Language_jvmKt.defaultLanguage(), null};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List languagesOrDefault = list;
        Comparator sortNames = (arg_0, arg_1) -> FeatureDictionary.getByTerm$lambda$11(search, canonicalSearch, arg_0, arg_1);
        Comparator sortMatchScore = FeatureDictionary::getByTerm$lambda$12;
        return SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Feature>, Continuation<? super Unit>, Object>(isSuggestion, this, (List<String>)languagesOrDefault, canonicalSearch, (Comparator<Feature>)sortNames, country, (Comparator<Feature>)sortMatchScore, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Boolean $isSuggestion;
            final /* synthetic */ FeatureDictionary this$0;
            final /* synthetic */ List<String> $languagesOrDefault;
            final /* synthetic */ String $canonicalSearch;
            final /* synthetic */ Comparator<Feature> $sortNames;
            final /* synthetic */ String $country;
            final /* synthetic */ Comparator<Feature> $sortMatchScore;
            {
                this.$isSuggestion = $isSuggestion;
                this.this$0 = $receiver;
                this.$languagesOrDefault = $languagesOrDefault;
                this.$canonicalSearch = $canonicalSearch;
                this.$sortNames = $sortNames;
                this.$country = $country;
                this.$sortMatchScore = $sortMatchScore;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        if (this.$isSuggestion == null || !this.$isSuggestion.booleanValue()) {
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yieldAll((Iterable)CollectionsKt.sortedWith((Iterable)FeatureDictionary.access$getNamesIndex(this.this$0, this.$languagesOrDefault).getAll(this.$canonicalSearch), this.$sortNames), (Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (this.$isSuggestion == null || this.$isSuggestion.booleanValue()) {
                            countryCodes = FeatureDictionaryKt.access$dissectCountryCode(this.$country);
                            this.L$0 = $this$sequence;
                            this.label = 2;
                            v1 = $this$sequence.yieldAll((Iterable)CollectionsKt.sortedWith((Iterable)FeatureDictionary.access$getBrandNamesIndex(this.this$0, countryCodes).getAll(this.$canonicalSearch), this.$sortNames), (Continuation)this);
                            if (v1 == var4_2) {
                                return var4_2;
                            }
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        if (this.$isSuggestion == null || !this.$isSuggestion.booleanValue()) {
                            this.L$0 = $this$sequence;
                            this.label = 3;
                            v2 = $this$sequence.yieldAll((Iterable)CollectionsKt.sortedWith((Iterable)FeatureDictionary.access$getTermsIndex(this.this$0, this.$languagesOrDefault).getAll(this.$canonicalSearch), this.$sortMatchScore), (Continuation)this);
                            if (v2 == var4_2) {
                                return var4_2;
                            }
                        }
                        ** GOTO lbl40
                    }
                    case 3: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl40:
                        // 2 sources

                        if (this.$isSuggestion == null || !this.$isSuggestion.booleanValue()) {
                            this.L$0 = null;
                            this.label = 4;
                            v3 = var2_3.yieldAll((Iterable)CollectionsKt.sortedWith((Iterable)FeatureDictionary.access$getTagValuesIndex(this.this$0, this.$languagesOrDefault).getAll(this.$canonicalSearch), this.$sortMatchScore), (Continuation)this);
                            if (v3 == var4_2) {
                                return var4_2;
                            }
                        }
                        ** GOTO lbl50
                    }
                    case 4: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl50:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super Feature> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }))), arg_0 -> FeatureDictionary.getByTerm$lambda$13(geometry, country, arg_0));
    }

    public static /* synthetic */ Sequence getByTerm$default(FeatureDictionary featureDictionary, String string, List list, String string2, GeometryType geometryType, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            geometryType = null;
        }
        if ((n & 0x10) != 0) {
            bl = null;
        }
        return featureDictionary.getByTerm(string, list, string2, geometryType, bl);
    }

    private final FeatureTagsIndex getTagsIndex(List<String> languages) {
        Object object;
        Map $this$getOrPut$iv = this.tagsIndexes;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(languages);
        if (value$iv == null) {
            boolean bl = false;
            Lazy answer$iv = LazyKt.lazy(() -> FeatureDictionary.getTagsIndex$lambda$15$lambda$14(this, languages));
            $this$getOrPut$iv.put(languages, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FeatureTagsIndex)((Lazy)object).getValue();
    }

    private final FeatureTagsIndex createTagsIndex(List<String> languages) {
        return new FeatureTagsIndex(this.featureCollection.getAll(languages));
    }

    private final FeatureTermIndex getNamesIndex(List<String> languages) {
        Object object;
        Map $this$getOrPut$iv = this.namesIndexes;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(languages);
        if (value$iv == null) {
            boolean bl = false;
            Lazy answer$iv = LazyKt.lazy(() -> FeatureDictionary.getNamesIndex$lambda$17$lambda$16(this, languages));
            $this$getOrPut$iv.put(languages, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FeatureTermIndex)((Lazy)object).getValue();
    }

    private final FeatureTermIndex createNamesIndex(List<String> languages) {
        return new FeatureTermIndex(this.featureCollection.getAll(languages), (Function1<? super Feature, ? extends List<String>>)((Function1)FeatureDictionary::createNamesIndex$lambda$18));
    }

    private final FeatureTermIndex getTermsIndex(List<String> languages) {
        Object object;
        Map $this$getOrPut$iv = this.termsIndexes;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(languages);
        if (value$iv == null) {
            boolean bl = false;
            Lazy answer$iv = LazyKt.lazy(() -> FeatureDictionary.getTermsIndex$lambda$20$lambda$19(this, languages));
            $this$getOrPut$iv.put(languages, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FeatureTermIndex)((Lazy)object).getValue();
    }

    private final FeatureTermIndex createTermsIndex(List<String> languages) {
        return new FeatureTermIndex(this.featureCollection.getAll(languages), (Function1<? super Feature, ? extends List<String>>)((Function1)FeatureDictionary::createTermsIndex$lambda$21));
    }

    private final FeatureTermIndex getTagValuesIndex(List<String> languages) {
        Object object;
        Map $this$getOrPut$iv = this.tagValuesIndexes;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(languages);
        if (value$iv == null) {
            boolean bl = false;
            Lazy answer$iv = LazyKt.lazy(() -> FeatureDictionary.getTagValuesIndex$lambda$23$lambda$22(this, languages));
            $this$getOrPut$iv.put(languages, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FeatureTermIndex)((Lazy)object).getValue();
    }

    private final FeatureTermIndex createTagValuesIndex(List<String> languages) {
        return new FeatureTermIndex(this.featureCollection.getAll(languages), (Function1<? super Feature, ? extends List<String>>)((Function1)FeatureDictionary::createTagValuesIndex$lambda$25));
    }

    private final FeatureTermIndex getBrandNamesIndex(List<String> countryCodes) {
        Object object;
        Map $this$getOrPut$iv = this.brandNamesIndexes;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(countryCodes);
        if (value$iv == null) {
            boolean bl = false;
            Lazy answer$iv = LazyKt.lazy(() -> FeatureDictionary.getBrandNamesIndex$lambda$27$lambda$26(this, countryCodes));
            $this$getOrPut$iv.put(countryCodes, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FeatureTermIndex)((Lazy)object).getValue();
    }

    private final FeatureTermIndex createBrandNamesIndex(List<String> countryCodes) {
        return this.brandFeatureCollection == null ? new FeatureTermIndex(CollectionsKt.emptyList(), (Function1<? super Feature, ? extends List<String>>)((Function1)FeatureDictionary::createBrandNamesIndex$lambda$28)) : new FeatureTermIndex(this.brandFeatureCollection.getAll(countryCodes), (Function1<? super Feature, ? extends List<String>>)((Function1)FeatureDictionary::createBrandNamesIndex$lambda$29));
    }

    private final FeatureTagsIndex getBrandTagsIndex(List<String> countryCodes) {
        Object object;
        Map $this$getOrPut$iv = this.brandTagsIndexes;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(countryCodes);
        if (value$iv == null) {
            boolean bl = false;
            Lazy answer$iv = LazyKt.lazy(() -> FeatureDictionary.getBrandTagsIndex$lambda$31$lambda$30(this, countryCodes));
            $this$getOrPut$iv.put(countryCodes, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (FeatureTagsIndex)((Lazy)object).getValue();
    }

    private final FeatureTagsIndex createBrandTagsIndex(List<String> countryCodes) {
        return this.brandFeatureCollection == null ? new FeatureTagsIndex(CollectionsKt.emptyList()) : new FeatureTagsIndex(this.brandFeatureCollection.getAll(countryCodes));
    }

    private static final boolean getByTags$lambda$0(GeometryType $geometry, String $country, Feature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !FeatureDictionaryKt.access$matches(it, $geometry, $country);
    }

    private static final boolean getByTags$lambda$1(HashSet $removeIds, Feature it) {
        Intrinsics.checkNotNullParameter((Object)$removeIds, (String)"$removeIds");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $removeIds.contains(it.getId());
    }

    private static final int getByTags$lambda$4(List $languagesOrDefault, Map $tags, Feature a, Feature b) {
        int n;
        Map.Entry it;
        int count$iv;
        int n2;
        int languageOrder;
        Intrinsics.checkNotNullParameter((Object)$languagesOrDefault, (String)"$languagesOrDefault");
        Intrinsics.checkNotNullParameter((Object)$tags, (String)"$tags");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int tagOrder = b.getTags().size() - a.getTags().size();
        if (tagOrder != 0) {
            return tagOrder;
        }
        if ($languagesOrDefault.size() == 1 && $languagesOrDefault.get(0) == null && (languageOrder = FeatureDictionaryKt.access$toInt(b.getIncludeCountryCodes().isEmpty() && b.getExcludeCountryCodes().isEmpty()) - FeatureDictionaryKt.access$toInt(a.getIncludeCountryCodes().isEmpty() && a.getExcludeCountryCodes().isEmpty())) != 0) {
            return languageOrder;
        }
        Iterable $this$count$iv = $tags.entrySet();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!b.getAddTags().entrySet().contains(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        $this$count$iv = $tags.entrySet();
        int n3 = n2;
        $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!a.getAddTags().entrySet().contains(it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n4 = n;
        int numberOfMatchedAddTags = n3 - n4;
        if (numberOfMatchedAddTags != 0) {
            return numberOfMatchedAddTags;
        }
        return (int)((float)100 * b.getMatchScore() - (float)100 * a.getMatchScore());
    }

    private static final int getByTerm$lambda$11(String $search, String $canonicalSearch, Feature a, Feature b) {
        boolean bl;
        boolean bl2;
        int n;
        block27: {
            boolean bl3;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block26: {
                boolean bl4;
                block25: {
                    boolean bl5;
                    boolean $i$f$any2;
                    Iterable $this$any$iv2;
                    block24: {
                        boolean bl6;
                        block23: {
                            String it;
                            boolean bl7;
                            boolean $i$f$any3;
                            Iterable $this$any$iv3;
                            block22: {
                                Intrinsics.checkNotNullParameter((Object)$search, (String)"$search");
                                Intrinsics.checkNotNullParameter((Object)$canonicalSearch, (String)"$canonicalSearch");
                                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                                $this$any$iv3 = b.getNames();
                                $i$f$any3 = false;
                                if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                    bl7 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv3) {
                                        it = (String)element$iv;
                                        boolean bl8 = false;
                                        if (!Intrinsics.areEqual((Object)it, (Object)$search)) continue;
                                        bl7 = true;
                                        break block22;
                                    }
                                    bl7 = false;
                                }
                            }
                            $this$any$iv3 = a.getNames();
                            n = FeatureDictionaryKt.access$toInt(bl7);
                            $i$f$any3 = false;
                            if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                                bl6 = false;
                            } else {
                                for (Object element$iv : $this$any$iv3) {
                                    it = (String)element$iv;
                                    boolean bl9 = false;
                                    if (!Intrinsics.areEqual((Object)it, (Object)$search)) continue;
                                    bl6 = true;
                                    break block23;
                                }
                                bl6 = false;
                            }
                        }
                        bl2 = bl6;
                        int exactMatchOrder = n - FeatureDictionaryKt.access$toInt(bl2);
                        if (exactMatchOrder != 0) {
                            return exactMatchOrder;
                        }
                        $this$any$iv2 = b.getCanonicalNames();
                        $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv2) {
                                String it = (String)element$iv;
                                boolean bl10 = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)$canonicalSearch)) continue;
                                bl5 = true;
                                break block24;
                            }
                            bl5 = false;
                        }
                    }
                    $this$any$iv2 = a.getCanonicalNames();
                    n = FeatureDictionaryKt.access$toInt(bl5);
                    $i$f$any2 = false;
                    if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv2) {
                            String it = (String)element$iv;
                            boolean bl11 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)$canonicalSearch)) continue;
                            bl4 = true;
                            break block25;
                        }
                        bl4 = false;
                    }
                }
                bl2 = bl4;
                int cExactMatchOrder = n - FeatureDictionaryKt.access$toInt(bl2);
                if (cExactMatchOrder != 0) {
                    return cExactMatchOrder;
                }
                $this$any$iv = b.getCanonicalNames();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl12 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)$canonicalSearch, (boolean)false, (int)2, null)) continue;
                        bl3 = true;
                        break block26;
                    }
                    bl3 = false;
                }
            }
            $this$any$iv = a.getCanonicalNames();
            n = FeatureDictionaryKt.access$toInt(bl3);
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl13 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)$canonicalSearch, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block27;
                }
                bl = false;
            }
        }
        bl2 = bl;
        int startsWithOrder = n - FeatureDictionaryKt.access$toInt(bl2);
        if (startsWithOrder != 0) {
            return startsWithOrder;
        }
        int matchScoreOrder = (int)((float)100 * b.getMatchScore() - (float)100 * a.getMatchScore());
        if (matchScoreOrder != 0) {
            return matchScoreOrder;
        }
        return a.getName().length() - b.getName().length();
    }

    private static final int getByTerm$lambda$12(Feature a, Feature b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return (int)((float)100 * b.getMatchScore() - (float)100 * a.getMatchScore());
    }

    private static final boolean getByTerm$lambda$13(GeometryType $geometry, String $country, Feature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FeatureDictionaryKt.access$matches(it, $geometry, $country);
    }

    private static final FeatureTagsIndex getTagsIndex$lambda$15$lambda$14(FeatureDictionary this$0, List $languages) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$languages, (String)"$languages");
        return this$0.createTagsIndex($languages);
    }

    private static final FeatureTermIndex getNamesIndex$lambda$17$lambda$16(FeatureDictionary this$0, List $languages) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$languages, (String)"$languages");
        return this$0.createNamesIndex($languages);
    }

    private static final List createNamesIndex$lambda$18(Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return SequencesKt.toList((Sequence)FeatureDictionaryKt.access$getSearchableNames(feature));
    }

    private static final FeatureTermIndex getTermsIndex$lambda$20$lambda$19(FeatureDictionary this$0, List $languages) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$languages, (String)"$languages");
        return this$0.createTermsIndex($languages);
    }

    private static final List createTermsIndex$lambda$21(Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return !feature.isSearchable() ? CollectionsKt.emptyList() : feature.getCanonicalTerms();
    }

    private static final FeatureTermIndex getTagValuesIndex$lambda$23$lambda$22(FeatureDictionary this$0, List $languages) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$languages, (String)"$languages");
        return this$0.createTagValuesIndex($languages);
    }

    /*
     * WARNING - void declaration
     */
    private static final List createTagValuesIndex$lambda$25(Feature feature) {
        List list;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        if (!feature.isSearchable()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = feature.getTags().values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)"*"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final FeatureTermIndex getBrandNamesIndex$lambda$27$lambda$26(FeatureDictionary this$0, List $countryCodes) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$countryCodes, (String)"$countryCodes");
        return this$0.createBrandNamesIndex($countryCodes);
    }

    private static final List createBrandNamesIndex$lambda$28(Feature it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.emptyList();
    }

    private static final List createBrandNamesIndex$lambda$29(Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return !feature.isSearchable() ? CollectionsKt.emptyList() : feature.getCanonicalNames();
    }

    private static final FeatureTagsIndex getBrandTagsIndex$lambda$31$lambda$30(FeatureDictionary this$0, List $countryCodes) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$countryCodes, (String)"$countryCodes");
        return this$0.createBrandTagsIndex($countryCodes);
    }

    public static final /* synthetic */ FeatureTermIndex access$getNamesIndex(FeatureDictionary $this, List languages) {
        return $this.getNamesIndex(languages);
    }

    public static final /* synthetic */ FeatureTermIndex access$getBrandNamesIndex(FeatureDictionary $this, List countryCodes) {
        return $this.getBrandNamesIndex(countryCodes);
    }

    public static final /* synthetic */ FeatureTermIndex access$getTermsIndex(FeatureDictionary $this, List languages) {
        return $this.getTermsIndex(languages);
    }

    public static final /* synthetic */ FeatureTermIndex access$getTagValuesIndex(FeatureDictionary $this, List languages) {
        return $this.getTagValuesIndex(languages);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a8\u0006\u000b"}, d2={"Lde/westnordost/osmfeatures/FeatureDictionary$Companion;", "", "<init>", "()V", "create", "Lde/westnordost/osmfeatures/FeatureDictionary;", "fileSystem", "Lkotlinx/io/files/FileSystem;", "presetsBasePath", "", "brandPresetsBasePath", "osmfeatures"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FeatureDictionary create(@NotNull FileSystem fileSystem, @NotNull String presetsBasePath, @Nullable String brandPresetsBasePath) {
            IDBrandPresetsFeatureCollection iDBrandPresetsFeatureCollection;
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter((Object)presetsBasePath, (String)"presetsBasePath");
            LocalizedFeatureCollection localizedFeatureCollection = new IDLocalizedFeatureCollection(new FileSystemAccess(fileSystem, presetsBasePath));
            String string = brandPresetsBasePath;
            if (string != null) {
                String string2 = string;
                LocalizedFeatureCollection localizedFeatureCollection2 = localizedFeatureCollection;
                boolean bl = false;
                iDBrandPresetsFeatureCollection = new IDBrandPresetsFeatureCollection(new FileSystemAccess(fileSystem, brandPresetsBasePath));
                localizedFeatureCollection = localizedFeatureCollection2;
            } else {
                iDBrandPresetsFeatureCollection = null;
            }
            PerCountryFeatureCollection perCountryFeatureCollection = iDBrandPresetsFeatureCollection;
            LocalizedFeatureCollection localizedFeatureCollection3 = localizedFeatureCollection;
            return new FeatureDictionary(localizedFeatureCollection3, perCountryFeatureCollection);
        }

        public static /* synthetic */ FeatureDictionary create$default(Companion companion, FileSystem fileSystem, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.create(fileSystem, string, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\t\u001a\u00060\u0000R\u00020\n2\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u000b\"\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\r\u001a\u00060\u0000R\u00020\n2\b\u0010\b\u001a\u0004\u0018\u00010\u0003J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/westnordost/osmfeatures/FeatureDictionary$QueryByIdBuilder;", "", "id", "", "<init>", "(Lde/westnordost/osmfeatures/FeatureDictionary;Ljava/lang/String;)V", "languages", "", "country", "inLanguage", "Lde/westnordost/osmfeatures/FeatureDictionary;", "", "([Ljava/lang/String;)Lde/westnordost/osmfeatures/FeatureDictionary$QueryByIdBuilder;", "inCountry", "get", "Lde/westnordost/osmfeatures/Feature;", "osmfeatures"})
    @SourceDebugExtension(value={"SMAP\nFeatureDictionary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureDictionary.kt\nde/westnordost/osmfeatures/FeatureDictionary$QueryByIdBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,483:1\n1#2:484\n*E\n"})
    public final class QueryByIdBuilder {
        @NotNull
        private final String id;
        @Nullable
        private List<String> languages;
        @Nullable
        private String country;

        public QueryByIdBuilder(String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final QueryByIdBuilder inLanguage(String ... languages) {
            QueryByIdBuilder queryByIdBuilder;
            Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
            QueryByIdBuilder $this$inLanguage_u24lambda_u240 = queryByIdBuilder = this;
            boolean bl = false;
            $this$inLanguage_u24lambda_u240.languages = ArraysKt.toList((Object[])languages);
            return queryByIdBuilder;
        }

        @NotNull
        public final QueryByIdBuilder inCountry(@Nullable String country) {
            QueryByIdBuilder queryByIdBuilder;
            QueryByIdBuilder $this$inCountry_u24lambda_u241 = queryByIdBuilder = this;
            boolean bl = false;
            $this$inCountry_u24lambda_u241.country = country;
            return queryByIdBuilder;
        }

        @Nullable
        public final Feature get() {
            return FeatureDictionary.this.getById(this.id, this.languages, this.country);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u000f\u001a\u00060\u0000R\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bJ'\u0010\u0011\u001a\u00060\u0000R\u00020\u00102\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\u0012\"\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\u00060\u0000R\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004J\u0019\u0010\u000b\u001a\u00060\u0000R\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/westnordost/osmfeatures/FeatureDictionary$QueryByTagBuilder;", "", "tags", "", "", "<init>", "(Lde/westnordost/osmfeatures/FeatureDictionary;Ljava/util/Map;)V", "geometry", "Lde/westnordost/osmfeatures/GeometryType;", "languages", "", "isSuggestion", "", "Ljava/lang/Boolean;", "country", "forGeometry", "Lde/westnordost/osmfeatures/FeatureDictionary;", "inLanguage", "", "([Ljava/lang/String;)Lde/westnordost/osmfeatures/FeatureDictionary$QueryByTagBuilder;", "inCountry", "(Ljava/lang/Boolean;)Lde/westnordost/osmfeatures/FeatureDictionary$QueryByTagBuilder;", "find", "Lde/westnordost/osmfeatures/Feature;", "osmfeatures"})
    @SourceDebugExtension(value={"SMAP\nFeatureDictionary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureDictionary.kt\nde/westnordost/osmfeatures/FeatureDictionary$QueryByTagBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,483:1\n1#2:484\n*E\n"})
    public final class QueryByTagBuilder {
        @NotNull
        private final Map<String, String> tags;
        @Nullable
        private GeometryType geometry;
        @Nullable
        private List<String> languages;
        @Nullable
        private Boolean isSuggestion;
        @Nullable
        private String country;

        public QueryByTagBuilder(Map<String, String> tags) {
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            this.tags = tags;
        }

        @NotNull
        public final QueryByTagBuilder forGeometry(@NotNull GeometryType geometry) {
            QueryByTagBuilder queryByTagBuilder;
            Intrinsics.checkNotNullParameter((Object)((Object)geometry), (String)"geometry");
            QueryByTagBuilder $this$forGeometry_u24lambda_u240 = queryByTagBuilder = this;
            boolean bl = false;
            $this$forGeometry_u24lambda_u240.geometry = geometry;
            return queryByTagBuilder;
        }

        @NotNull
        public final QueryByTagBuilder inLanguage(String ... languages) {
            QueryByTagBuilder queryByTagBuilder;
            Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
            QueryByTagBuilder $this$inLanguage_u24lambda_u241 = queryByTagBuilder = this;
            boolean bl = false;
            $this$inLanguage_u24lambda_u241.languages = ArraysKt.toList((Object[])languages);
            return queryByTagBuilder;
        }

        @NotNull
        public final QueryByTagBuilder inCountry(@Nullable String country) {
            QueryByTagBuilder queryByTagBuilder;
            QueryByTagBuilder $this$inCountry_u24lambda_u242 = queryByTagBuilder = this;
            boolean bl = false;
            $this$inCountry_u24lambda_u242.country = country;
            return queryByTagBuilder;
        }

        @NotNull
        public final QueryByTagBuilder isSuggestion(@Nullable Boolean isSuggestion) {
            QueryByTagBuilder queryByTagBuilder;
            QueryByTagBuilder $this$isSuggestion_u24lambda_u243 = queryByTagBuilder = this;
            boolean bl = false;
            $this$isSuggestion_u24lambda_u243.isSuggestion = isSuggestion;
            return queryByTagBuilder;
        }

        @NotNull
        public final List<Feature> find() {
            return FeatureDictionary.this.getByTags(this.tags, this.languages, this.country, this.geometry, this.isSuggestion);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000e\u001a\u00060\u0000R\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J'\u0010\u0011\u001a\u00060\u0000R\u00020\u000f2\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030\u0012\"\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\u00060\u0000R\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0003J\u0019\u0010\n\u001a\u00060\u0000R\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/westnordost/osmfeatures/FeatureDictionary$QueryByTermBuilder;", "", "term", "", "<init>", "(Lde/westnordost/osmfeatures/FeatureDictionary;Ljava/lang/String;)V", "geometry", "Lde/westnordost/osmfeatures/GeometryType;", "languages", "", "isSuggestion", "", "Ljava/lang/Boolean;", "country", "forGeometry", "Lde/westnordost/osmfeatures/FeatureDictionary;", "geometryType", "inLanguage", "", "([Ljava/lang/String;)Lde/westnordost/osmfeatures/FeatureDictionary$QueryByTermBuilder;", "inCountry", "countryCode", "suggestion", "(Ljava/lang/Boolean;)Lde/westnordost/osmfeatures/FeatureDictionary$QueryByTermBuilder;", "find", "Lkotlin/sequences/Sequence;", "Lde/westnordost/osmfeatures/Feature;", "osmfeatures"})
    @SourceDebugExtension(value={"SMAP\nFeatureDictionary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureDictionary.kt\nde/westnordost/osmfeatures/FeatureDictionary$QueryByTermBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,483:1\n1#2:484\n*E\n"})
    public final class QueryByTermBuilder {
        @NotNull
        private final String term;
        @Nullable
        private GeometryType geometry;
        @Nullable
        private List<String> languages;
        @Nullable
        private Boolean isSuggestion;
        @Nullable
        private String country;

        public QueryByTermBuilder(String term) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            this.term = term;
        }

        @NotNull
        public final QueryByTermBuilder forGeometry(@NotNull GeometryType geometryType) {
            QueryByTermBuilder queryByTermBuilder;
            Intrinsics.checkNotNullParameter((Object)((Object)geometryType), (String)"geometryType");
            QueryByTermBuilder $this$forGeometry_u24lambda_u240 = queryByTermBuilder = this;
            boolean bl = false;
            $this$forGeometry_u24lambda_u240.geometry = geometryType;
            return queryByTermBuilder;
        }

        @NotNull
        public final QueryByTermBuilder inLanguage(String ... languages) {
            QueryByTermBuilder queryByTermBuilder;
            Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
            QueryByTermBuilder $this$inLanguage_u24lambda_u241 = queryByTermBuilder = this;
            boolean bl = false;
            $this$inLanguage_u24lambda_u241.languages = ArraysKt.toList((Object[])languages);
            return queryByTermBuilder;
        }

        @NotNull
        public final QueryByTermBuilder inCountry(@Nullable String countryCode) {
            QueryByTermBuilder queryByTermBuilder;
            QueryByTermBuilder $this$inCountry_u24lambda_u242 = queryByTermBuilder = this;
            boolean bl = false;
            $this$inCountry_u24lambda_u242.country = countryCode;
            return queryByTermBuilder;
        }

        @NotNull
        public final QueryByTermBuilder isSuggestion(@Nullable Boolean suggestion) {
            QueryByTermBuilder queryByTermBuilder;
            QueryByTermBuilder $this$isSuggestion_u24lambda_u243 = queryByTermBuilder = this;
            boolean bl = false;
            $this$isSuggestion_u24lambda_u243.isSuggestion = suggestion;
            return queryByTermBuilder;
        }

        @NotNull
        public final Sequence<Feature> find() {
            return FeatureDictionary.this.getByTerm(this.term, this.languages, this.country, this.geometry, this.isSuggestion);
        }
    }
}

