/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmfeatures;

import de.westnordost.osmfeatures.Feature;
import de.westnordost.osmfeatures.StartsWithStringTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0012\u001a\u00020\bR \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/westnordost/osmfeatures/FeatureTermIndex;", "", "features", "", "Lde/westnordost/osmfeatures/Feature;", "getStrings", "Lkotlin/Function1;", "", "", "<init>", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)V", "featureMap", "Ljava/util/HashMap;", "", "tree", "Lde/westnordost/osmfeatures/StartsWithStringTree;", "getAll", "", "startsWith", "osmfeatures"})
@SourceDebugExtension(value={"SMAP\nFeatureTermIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureTermIndex.kt\nde/westnordost/osmfeatures/FeatureTermIndex\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,31:1\n381#2,7:32\n*S KotlinDebug\n*F\n+ 1 FeatureTermIndex.kt\nde/westnordost/osmfeatures/FeatureTermIndex\n*L\n15#1:32,7\n*E\n"})
public final class FeatureTermIndex {
    @NotNull
    private final HashMap<String, List<Feature>> featureMap;
    @NotNull
    private final StartsWithStringTree tree;

    public FeatureTermIndex(@NotNull Collection<? extends Feature> features, @NotNull Function1<? super Feature, ? extends List<String>> getStrings) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter(getStrings, (String)"getStrings");
        this.featureMap = new HashMap(features.size());
        for (Feature feature : features) {
            for (String string : (List)getStrings.invoke((Object)feature)) {
                Object object;
                Map $this$getOrPut$iv = this.featureMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(string);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList(1);
                    $this$getOrPut$iv.put(string, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List map = (List)object;
                map.add(feature);
            }
        }
        Set<String> set = this.featureMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        this.tree = new StartsWithStringTree(set, 0, 0, 6, null);
    }

    @NotNull
    public final Set<Feature> getAll(@NotNull String startsWith) {
        Intrinsics.checkNotNullParameter((Object)startsWith, (String)"startsWith");
        HashSet result = new HashSet();
        for (String string : this.tree.getAll(startsWith)) {
            List<Feature> fs = this.featureMap.get(string);
            if (fs == null) continue;
            result.addAll(fs);
        }
        return result;
    }
}

