/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.osmfeatures;

import de.westnordost.osmfeatures.ResourceAccessAdapter;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.CoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Source;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.PathsJvmKt;
import kotlinx.io.files.PathsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/westnordost/osmfeatures/FileSystemAccess;", "Lde/westnordost/osmfeatures/ResourceAccessAdapter;", "fileSystem", "Lkotlinx/io/files/FileSystem;", "basePath", "", "<init>", "(Lkotlinx/io/files/FileSystem;Ljava/lang/String;)V", "exists", "", "name", "open", "Lkotlinx/io/Source;", "osmfeatures"})
@SourceDebugExtension(value={"SMAP\nFileSystemAccess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemAccess.kt\nde/westnordost/osmfeatures/FileSystemAccess\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n1#2:28\n*E\n"})
public final class FileSystemAccess
implements ResourceAccessAdapter {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final String basePath;

    public FileSystemAccess(@NotNull FileSystem fileSystem, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.fileSystem = fileSystem;
        this.basePath = basePath;
        FileMetadata metadata = this.fileSystem.metadataOrNull(PathsJvmKt.Path((String)this.basePath));
        if (!(metadata != null)) {
            boolean $i$a$-require-FileSystemAccess$32 = false;
            String $i$a$-require-FileSystemAccess$32 = this.basePath + " does not exist";
            throw new IllegalArgumentException($i$a$-require-FileSystemAccess$32.toString());
        }
        if (!metadata.isDirectory()) {
            boolean bl = false;
            String string = this.basePath + " is not a directory";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public boolean exists(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{name};
        return this.fileSystem.exists(PathsKt.Path((String)this.basePath, (String[])stringArray));
    }

    @Override
    @NotNull
    public Source open(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{name};
        return CoreKt.buffered((RawSource)this.fileSystem.source(PathsKt.Path((String)this.basePath, (String[])stringArray)));
    }
}

