/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.region_index;

import de.westnordost.region_index.Cell;
import de.westnordost.region_index.Point;
import de.westnordost.region_index.RegionIndexKt;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 32\u00020\u0001:\u00013B3\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019J\u001e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\tJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nJ,\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ,\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ.\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0002J\u0018\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006H\u0002J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u001f\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b.\u0010/J\u001f\u00100\u001a\u00020,2\u0006\u00101\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b2\u0010/R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lde/westnordost/region_index/RegionIndex;", "", "raster", "", "Lde/westnordost/region_index/Cell;", "rasterWidth", "", "geometrySizes", "", "", "", "<init>", "(Ljava/util/List;ILjava/util/Map;)V", "getRaster$region_index", "()Ljava/util/List;", "getRasterWidth$region_index", "()I", "getGeometrySizes$region_index", "()Ljava/util/Map;", "rasterHeight", "isInAny", "", "longitude", "latitude", "ids", "", "isIn", "id", "getIds", "getContainingIds", "", "minLongitude", "minLatitude", "maxLongitude", "maxLatitude", "getIntersectingIds", "cellsIn", "Lkotlin/sequences/Sequence;", "getCell", "x", "y", "longitudeToCellX", "latitudeToCellY", "longitudeToLocalX", "Lkotlin/UShort;", "cellX", "longitudeToLocalX-ErzVvmY", "(ID)S", "latitudeToLocalY", "cellY", "latitudeToLocalY-ErzVvmY", "Companion", "region-index"})
@SourceDebugExtension(value={"SMAP\nRegionIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegionIndex.kt\nde/westnordost/region_index/RegionIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1056#2:215\n*S KotlinDebug\n*F\n+ 1 RegionIndex.kt\nde/westnordost/region_index/RegionIndex\n*L\n72#1:215\n*E\n"})
public final class RegionIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Cell> raster;
    private final int rasterWidth;
    @NotNull
    private final Map<String, Double> geometrySizes;
    private final int rasterHeight;

    public RegionIndex(@NotNull List<Cell> raster, int rasterWidth, @NotNull Map<String, Double> geometrySizes) {
        Intrinsics.checkNotNullParameter(raster, (String)"raster");
        Intrinsics.checkNotNullParameter(geometrySizes, (String)"geometrySizes");
        this.raster = raster;
        this.rasterWidth = rasterWidth;
        this.geometrySizes = geometrySizes;
        this.rasterHeight = this.raster.size() / this.rasterWidth;
    }

    @NotNull
    public final List<Cell> getRaster$region_index() {
        return this.raster;
    }

    public final int getRasterWidth$region_index() {
        return this.rasterWidth;
    }

    @NotNull
    public final Map<String, Double> getGeometrySizes$region_index() {
        return this.geometrySizes;
    }

    public final boolean isInAny(double longitude, double latitude, @NotNull Collection<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        double longitude2 = longitude;
        RegionIndexKt.access$validatePosition(longitude2, latitude);
        longitude2 = RegionIndexKt.access$normalizeLongitude(longitude2);
        int cellX = this.longitudeToCellX(longitude2);
        int cellY = this.latitudeToCellY(latitude);
        short localX = this.longitudeToLocalX-ErzVvmY(cellX, longitude2);
        short localY = this.latitudeToLocalY-ErzVvmY(cellY, latitude);
        return this.getCell(cellX, cellY).isInAny(new Point(localX, localY, null), ids);
    }

    public final boolean isIn(double longitude, double latitude, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.isInAny(longitude, latitude, CollectionsKt.listOf((Object)id));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getIds(double longitude, double latitude) {
        void $this$sortedBy$iv;
        double longitude2 = longitude;
        RegionIndexKt.access$validatePosition(longitude2, latitude);
        longitude2 = RegionIndexKt.access$normalizeLongitude(longitude2);
        int cellX = this.longitudeToCellX(longitude2);
        int cellY = this.latitudeToCellY(latitude);
        short localX = this.longitudeToLocalX-ErzVvmY(cellX, longitude2);
        short localY = this.latitudeToLocalY-ErzVvmY(cellY, latitude);
        Iterable iterable = this.getCell(cellX, cellY).getIds(new Point(localX, localY, null));
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(this){
            final /* synthetic */ RegionIndex this$0;
            {
                this.this$0 = regionIndex;
            }

            public final int compare(T a, T b) {
                String it = (String)a;
                boolean bl = false;
                Double d = this.this$0.getGeometrySizes$region_index().get(it);
                it = (String)b;
                Comparable comparable = Double.valueOf(d != null ? d : 0.0);
                bl = false;
                Double d2 = this.this$0.getGeometrySizes$region_index().get(it);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(d2 != null ? d2 : 0.0));
            }
        });
    }

    @NotNull
    public final Set<String> getContainingIds(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        HashSet<String> ids = new HashSet<String>();
        boolean firstCell = true;
        for (Cell cell : this.cellsIn(minLongitude, minLatitude, maxLongitude, maxLatitude)) {
            if (firstCell) {
                ids.addAll(cell.getContainingIds());
                firstCell = false;
                continue;
            }
            ids.retainAll(cell.getContainingIds());
            if (!ids.isEmpty()) continue;
            break;
        }
        return ids;
    }

    @NotNull
    public final Set<String> getIntersectingIds(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        HashSet<String> ids = new HashSet<String>();
        for (Cell cell : this.cellsIn(minLongitude, minLatitude, maxLongitude, maxLatitude)) {
            ids.addAll(cell.getAllIds());
        }
        return ids;
    }

    private final Sequence<Cell> cellsIn(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Cell>, Continuation<? super Unit>, Object>(minLongitude, maxLongitude, minLatitude, maxLatitude, this, null){
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            int I$5;
            int I$6;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ double $minLongitude;
            final /* synthetic */ double $maxLongitude;
            final /* synthetic */ double $minLatitude;
            final /* synthetic */ double $maxLatitude;
            final /* synthetic */ RegionIndex this$0;
            {
                this.$minLongitude = $minLongitude;
                this.$maxLongitude = $maxLongitude;
                this.$minLatitude = $minLatitude;
                this.$maxLatitude = $maxLatitude;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        minLongitude = this.$minLongitude;
                        maxLongitude = this.$maxLongitude;
                        RegionIndexKt.access$validateBounds(minLongitude, this.$minLatitude, maxLongitude, this.$maxLatitude);
                        minLongitude = RegionIndexKt.access$normalizeLongitude(minLongitude);
                        maxLongitude = RegionIndexKt.access$normalizeLongitude(maxLongitude);
                        minX = RegionIndex.access$longitudeToCellX(this.this$0, minLongitude);
                        maxY = RegionIndex.access$latitudeToCellY(this.this$0, this.$minLatitude);
                        maxX = RegionIndex.access$longitudeToCellX(this.this$0, maxLongitude);
                        minY = RegionIndex.access$latitudeToCellY(this.this$0, this.$maxLatitude);
                        stepsX = minX > maxX ? this.this$0.getRasterWidth$region_index() - minX + maxX : maxX - minX;
                        xStep = 0;
                        if (xStep > stepsX) ** GOTO lbl51
lbl18:
                        // 2 sources

                        while (true) {
                            x = (minX + xStep) % this.this$0.getRasterWidth$region_index();
                            y = minY;
                            if (y <= maxY) {
                                while (true) {
                                    this.L$0 = $this$sequence;
                                    this.I$0 = minX;
                                    this.I$1 = maxY;
                                    this.I$2 = minY;
                                    this.I$3 = stepsX;
                                    this.I$4 = xStep;
                                    this.I$5 = x;
                                    this.I$6 = ++y;
                                    this.label = 1;
                                    v0 = $this$sequence.yield((Object)RegionIndex.access$getCell(this.this$0, x, y), (Continuation)this);
                                    if (v0 != var15_2) continue;
                                    return var15_2;
                                }
                            }
                            ** GOTO lbl48
                            break;
                        }
                    }
                    case 1: {
                        y = this.I$6;
                        x = this.I$5;
                        xStep = this.I$4;
                        stepsX = this.I$3;
                        minY = this.I$2;
                        maxY = this.I$1;
                        minX = this.I$0;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        if (y != maxY) ** continue;
lbl48:
                        // 2 sources

                        if (xStep != stepsX) {
                            ++xStep;
                            ** continue;
                        }
lbl51:
                        // 3 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super Cell> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Cell getCell(int x, int y) {
        return this.raster.get(y * this.rasterWidth + x);
    }

    private final int longitudeToCellX(double longitude) {
        return RangesKt.coerceAtMost((int)((int)Math.floor((double)this.rasterWidth * ((double)180 + longitude) / 360.0)), (int)(this.rasterWidth - 1));
    }

    private final int latitudeToCellY(double latitude) {
        return RangesKt.coerceAtLeast((int)((int)(Math.ceil((double)this.rasterHeight * ((double)90 - latitude) / 180.0) - 1.0)), (int)0);
    }

    private final short longitudeToLocalX-ErzVvmY(int cellX, double longitude) {
        double cellLongitude = -180.0 + 360.0 * (double)cellX / (double)this.rasterWidth;
        return UShort.constructor-impl((short)((short)((longitude - cellLongitude) * (double)this.rasterWidth * (double)65535 / 360.0)));
    }

    private final short latitudeToLocalY-ErzVvmY(int cellY, double latitude) {
        double cellLatitude = (double)90 - 180.0 * (double)(cellY + 1) / (double)this.rasterHeight;
        return UShort.constructor-impl((short)((short)((latitude - cellLatitude) * (double)this.rasterHeight * (double)65535 / 180.0)));
    }

    public static final /* synthetic */ int access$longitudeToCellX(RegionIndex $this, double longitude) {
        return $this.longitudeToCellX(longitude);
    }

    public static final /* synthetic */ int access$latitudeToCellY(RegionIndex $this, double latitude) {
        return $this.latitudeToCellY(latitude);
    }

    public static final /* synthetic */ Cell access$getCell(RegionIndex $this, int x, int y) {
        return $this.getCell(x, y);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lde/westnordost/region_index/RegionIndex$Companion;", "", "<init>", "()V", "region-index"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

