/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.region_index;

import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a \u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u00a8\u0006\u000f"}, d2={"validateBounds", "", "minLongitude", "", "minLatitude", "maxLongitude", "maxLatitude", "validatePosition", "longitude", "latitude", "normalizeLongitude", "normalize", "value", "startAt", "base", "region-index"})
@SourceDebugExtension(value={"SMAP\nRegionIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegionIndex.kt\nde/westnordost/region_index/RegionIndexKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1#2:215\n*E\n"})
public final class RegionIndexKt {
    private static final void validateBounds(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        if (!(Math.abs(minLongitude) <= Double.MAX_VALUE)) {
            boolean $i$a$-require-RegionIndexKt$validateBounds$82 = false;
            String $i$a$-require-RegionIndexKt$validateBounds$82 = "minLongitude must be finite";
            throw new IllegalArgumentException($i$a$-require-RegionIndexKt$validateBounds$82.toString());
        }
        if (!(Math.abs(minLatitude) <= Double.MAX_VALUE)) {
            boolean $i$a$-require-RegionIndexKt$validateBounds$92 = false;
            String $i$a$-require-RegionIndexKt$validateBounds$92 = "minLatitude must be finite";
            throw new IllegalArgumentException($i$a$-require-RegionIndexKt$validateBounds$92.toString());
        }
        if (!(Math.abs(maxLongitude) <= Double.MAX_VALUE)) {
            boolean $i$a$-require-RegionIndexKt$validateBounds$102 = false;
            String $i$a$-require-RegionIndexKt$validateBounds$102 = "maxLongitude must be finite";
            throw new IllegalArgumentException($i$a$-require-RegionIndexKt$validateBounds$102.toString());
        }
        if (!(Math.abs(maxLatitude) <= Double.MAX_VALUE)) {
            boolean $i$a$-require-RegionIndexKt$validateBounds$112 = false;
            String $i$a$-require-RegionIndexKt$validateBounds$112 = "maxLatitude must be finite";
            throw new IllegalArgumentException($i$a$-require-RegionIndexKt$validateBounds$112.toString());
        }
        if (!(minLatitude >= -90.0 && minLatitude <= 90.0)) {
            boolean $i$a$-require-RegionIndexKt$validateBounds$122 = false;
            String $i$a$-require-RegionIndexKt$validateBounds$122 = "minLatitude is out of bounds";
            throw new IllegalArgumentException($i$a$-require-RegionIndexKt$validateBounds$122.toString());
        }
        if (!(maxLatitude >= -90.0 && maxLatitude <= 90.0)) {
            boolean $i$a$-require-RegionIndexKt$validateBounds$132 = false;
            String $i$a$-require-RegionIndexKt$validateBounds$132 = "maxLatitude is out of bounds";
            throw new IllegalArgumentException($i$a$-require-RegionIndexKt$validateBounds$132.toString());
        }
        if (!(minLatitude <= maxLatitude)) {
            boolean bl = false;
            String string = "maxLatitude is smaller than minLatitude";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final void validatePosition(double longitude, double latitude) {
        if (!(Math.abs(longitude) <= Double.MAX_VALUE)) {
            boolean $i$a$-require-RegionIndexKt$validatePosition$42 = false;
            String $i$a$-require-RegionIndexKt$validatePosition$42 = "longitude must be finite";
            throw new IllegalArgumentException($i$a$-require-RegionIndexKt$validatePosition$42.toString());
        }
        if (!(Math.abs(latitude) <= Double.MAX_VALUE)) {
            boolean $i$a$-require-RegionIndexKt$validatePosition$52 = false;
            String $i$a$-require-RegionIndexKt$validatePosition$52 = "latitude must be finite";
            throw new IllegalArgumentException($i$a$-require-RegionIndexKt$validatePosition$52.toString());
        }
        if (!(latitude >= -90.0 && latitude <= 90.0)) {
            boolean bl = false;
            String string = "latitude is out of bounds";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final double normalizeLongitude(double longitude) {
        return RegionIndexKt.normalize(longitude, -180.0, 360.0);
    }

    private static final double normalize(double value, double startAt, double base) {
        double value2 = value;
        if ((value2 %= base) < startAt) {
            value2 += base;
        } else if (value2 >= startAt + base) {
            value2 -= base;
        }
        return value2;
    }

    public static final /* synthetic */ void access$validatePosition(double longitude, double latitude) {
        RegionIndexKt.validatePosition(longitude, latitude);
    }

    public static final /* synthetic */ double access$normalizeLongitude(double longitude) {
        return RegionIndexKt.normalizeLongitude(longitude);
    }

    public static final /* synthetic */ void access$validateBounds(double minLongitude, double minLatitude, double maxLongitude, double maxLatitude) {
        RegionIndexKt.validateBounds(minLongitude, minLatitude, maxLongitude, maxLatitude);
    }
}

