/*
 * Decompiled with CFR 0.152.
 */
package de.westnordost.region_index;

import de.westnordost.region_index.Areas;
import de.westnordost.region_index.Cell;
import de.westnordost.region_index.Point;
import de.westnordost.region_index.RegionIndex;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.Sink;
import kotlinx.io.SinksKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\r\u001a\u00020\u0001*\u00020\u00042\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000fH\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u0001*\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0015\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"serializeTo", "", "Lde/westnordost/region_index/RegionIndex;", "sink", "Lkotlinx/io/Sink;", "writeRegionIndex", "index", "writeCell", "cell", "Lde/westnordost/region_index/Cell;", "writeAreas", "areas", "Lde/westnordost/region_index/Areas;", "writePolygons", "polygons", "", "Lde/westnordost/region_index/Point;", "writeRing", "points", "writePoint", "point", "writeUTF", "string", "", "region-index"})
@SourceDebugExtension(value={"SMAP\nserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 serializer.kt\nde/westnordost/region_index/SerializerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class SerializerKt {
    public static final void serializeTo(@NotNull RegionIndex $this$serializeTo, @NotNull Sink sink) {
        Intrinsics.checkNotNullParameter((Object)$this$serializeTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        SerializerKt.writeRegionIndex(sink, $this$serializeTo);
    }

    private static final void writeRegionIndex(Sink $this$writeRegionIndex, RegionIndex index) {
        SinksKt.writeUShort-i8woANY((Sink)$this$writeRegionIndex, (short)2);
        $this$writeRegionIndex.writeInt(index.getGeometrySizes$region_index().size());
        for (Map.Entry<String, Double> entry : index.getGeometrySizes$region_index().entrySet()) {
            String id = entry.getKey();
            double size = ((Number)entry.getValue()).doubleValue();
            SerializerKt.writeUTF($this$writeRegionIndex, id);
            SinksKt.writeDouble((Sink)$this$writeRegionIndex, (double)size);
        }
        $this$writeRegionIndex.writeInt(index.getRasterWidth$region_index());
        $this$writeRegionIndex.writeInt(index.getRaster$region_index().size());
        for (Cell cell : index.getRaster$region_index()) {
            SerializerKt.writeCell($this$writeRegionIndex, cell);
        }
    }

    private static final void writeCell(Sink $this$writeCell, Cell cell) {
        int containingIdsSize = cell.getContainingIds().size();
        if (!(containingIdsSize <= (0xFFFFFFFF & 0xFF))) {
            boolean $i$a$-require-SerializerKt$writeCell$32 = false;
            String $i$a$-require-SerializerKt$writeCell$32 = "At most 255 different areas per cell are supported (try a bigger raster)";
            throw new IllegalArgumentException($i$a$-require-SerializerKt$writeCell$32.toString());
        }
        SinksKt.writeUByte-EK-6454((Sink)$this$writeCell, (byte)UByte.constructor-impl((byte)((byte)containingIdsSize)));
        for (String id : cell.getContainingIds()) {
            SerializerKt.writeUTF($this$writeCell, id);
        }
        int intersectingAreasSize = cell.getIntersectingAreas().size();
        if (!(intersectingAreasSize <= (0xFFFFFFFF & 0xFF))) {
            boolean $i$a$-require-SerializerKt$writeCell$42 = false;
            String $i$a$-require-SerializerKt$writeCell$42 = "At most 255 different areas per cell are supported (try a bigger raster)";
            throw new IllegalArgumentException($i$a$-require-SerializerKt$writeCell$42.toString());
        }
        SinksKt.writeUByte-EK-6454((Sink)$this$writeCell, (byte)UByte.constructor-impl((byte)((byte)intersectingAreasSize)));
        for (Areas areas : cell.getIntersectingAreas()) {
            SerializerKt.writeAreas($this$writeCell, areas);
        }
    }

    private static final void writeAreas(Sink $this$writeAreas, Areas areas) {
        SerializerKt.writeUTF($this$writeAreas, areas.getId$region_index());
        SerializerKt.writePolygons($this$writeAreas, areas.getOuter$region_index());
        SerializerKt.writePolygons($this$writeAreas, areas.getInner$region_index());
    }

    private static final void writePolygons(Sink $this$writePolygons, List<? extends List<Point>> polygons) {
        int polygonsCount = polygons.size();
        if (!(polygonsCount <= (0xFFFFFFFF & 0xFF))) {
            boolean bl = false;
            String string = "At most 255 different polygons are supported per area (try a bigger raster)";
            throw new IllegalArgumentException(string.toString());
        }
        SinksKt.writeUByte-EK-6454((Sink)$this$writePolygons, (byte)UByte.constructor-impl((byte)((byte)polygons.size())));
        for (List<Point> list : polygons) {
            SerializerKt.writeRing($this$writePolygons, list);
        }
    }

    private static final void writeRing(Sink $this$writeRing, List<Point> points) {
        $this$writeRing.writeInt(points.size());
        for (Point point : points) {
            SerializerKt.writePoint($this$writeRing, point);
        }
    }

    private static final void writePoint(Sink $this$writePoint, Point point) {
        SinksKt.writeUShort-i8woANY((Sink)$this$writePoint, (short)point.getX-Mh2AYeg());
        SinksKt.writeUShort-i8woANY((Sink)$this$writePoint, (short)point.getY-Mh2AYeg());
    }

    private static final void writeUTF(Sink $this$writeUTF, String string) {
        byte[] bytes = StringsKt.encodeToByteArray((String)string);
        if (!(bytes.length <= (0xFFFFFFFF & 0xFFFF))) {
            boolean bl = false;
            String string2 = "ID too long";
            throw new IllegalArgumentException(string2.toString());
        }
        SinksKt.writeUShort-i8woANY((Sink)$this$writeUTF, (short)UShort.constructor-impl((short)((short)bytes.length)));
        Sink.write$default((Sink)$this$writeUTF, (byte[])bytes, (int)0, (int)0, (int)6, null);
    }
}

