package de.westnordost.region_index

/** Represents the areas that one region with the given id covers.  */
internal data class Areas(
    internal val id: String,
    internal val outer: List<List<Point>>,
    internal val inner: List<List<Point>>
) {
    /** Returns whether it contains the given point  */
    fun covers(point: Point): Boolean =
        outer.count { point.isInPolygon(it) } - inner.count { point.isInPolygon(it) } > 0
}
