/*
 * Decompiled with CFR 0.152.
 */
package de.wuespace.telestion.application;

import de.wuespace.telestion.services.config.Configuration;
import io.vertx.config.ConfigRetriever;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Telestion
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(Telestion.class);

    public static void main(String[] args) {
        Vertx vertx = Vertx.vertx();
        vertx.deployVerticle(Telestion.class.getName());
    }

    public void start(Promise<Void> startPromise) {
        ConfigRetriever retriever = ConfigRetriever.create((Vertx)this.vertx);
        retriever.getConfig(configRes -> {
            if (configRes.failed()) {
                logger.error("Failed to load config", configRes.cause());
                startPromise.fail(configRes.cause());
                return;
            }
            Configuration conf = (Configuration)((JsonObject)configRes.result()).getJsonObject("org.telestion.configuration").mapTo(Configuration.class);
            conf.verticles().stream().flatMap(c -> Collections.nCopies(c.magnitude(), c).stream()).forEach(v -> {
                logger.info("Deploying {}", (Object)v.name());
                Future future = this.vertx.deployVerticle(v.verticle(), new DeploymentOptions().setConfig(v.jsonConfig()));
                future.onFailure(Throwable::printStackTrace);
            });
            startPromise.complete();
        });
    }

    public void stop(Promise<Void> stopPromise) throws Exception {
    }
}

