/*
 * Decompiled with CFR 0.152.
 */
package de.wuespace.telestion.launcher;

import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Launcher {
    private static final Logger logger = LoggerFactory.getLogger(Launcher.class);

    public static void main(String[] args) {
        Launcher.start(args);
    }

    public static void start(String ... verticleNames) {
        logger.info("Deploying {} verticles", (Object)verticleNames.length);
        Vertx vertx = Vertx.vertx();
        Arrays.stream(verticleNames).forEach(verticleName -> {
            logger.info("Deploying verticle {}", verticleName);
            vertx.setPeriodic(Duration.ofSeconds(5L).toMillis(), timerId -> vertx.deployVerticle(verticleName, res -> {
                if (res.failed()) {
                    logger.error("Failed to deploy verticle {} retrying in 5s", verticleName, (Object)res.cause());
                    return;
                }
                logger.info("Deployed verticle {} with id {}", verticleName, res.result());
                vertx.cancelTimer(timerId.longValue());
            }));
        });
    }

    public static void start(Verticle ... verticles) {
        logger.info("Deploying {} verticles", (Object)verticles.length);
        Vertx vertx = Vertx.vertx();
        Arrays.stream(verticles).forEach(verticleName -> {
            logger.info("Deploying verticle {}", verticleName);
            vertx.setPeriodic(Duration.ofSeconds(5L).toMillis(), timerId -> vertx.deployVerticle(verticleName, res -> {
                if (res.failed()) {
                    logger.error("Failed to deploy verticle {} retrying in 5s", verticleName, (Object)res.cause());
                    return;
                }
                logger.info("Deployed verticle {} with id {}", verticleName, res.result());
                vertx.cancelTimer(timerId.longValue());
            }));
        });
    }
}

