/*
 * Decompiled with CFR 0.152.
 */
package dev.bnorm.storyboard;

import androidx.compose.runtime.ComposableInferredTarget;
import dev.bnorm.storyboard.Scene;
import dev.bnorm.storyboard.SceneContent;
import dev.bnorm.storyboard.SceneDecorator;
import dev.bnorm.storyboard.SceneDecoratorKt;
import dev.bnorm.storyboard.SceneEnterTransition;
import dev.bnorm.storyboard.SceneExitTransition;
import dev.bnorm.storyboard.StoryboardBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J@\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/bnorm/storyboard/DecoratedStoryboardBuilder;", "Ldev/bnorm/storyboard/StoryboardBuilder;", "upstream", "decorator", "Ldev/bnorm/storyboard/SceneDecorator;", "<init>", "(Ldev/bnorm/storyboard/StoryboardBuilder;Ldev/bnorm/storyboard/SceneDecorator;)V", "scene", "Ldev/bnorm/storyboard/Scene;", "T", "states", "", "enterTransition", "Ldev/bnorm/storyboard/SceneEnterTransition;", "exitTransition", "Ldev/bnorm/storyboard/SceneExitTransition;", "content", "Ldev/bnorm/storyboard/SceneContent;", "storyboard"})
final class DecoratedStoryboardBuilder
implements StoryboardBuilder {
    @NotNull
    private final StoryboardBuilder upstream;
    @NotNull
    private final SceneDecorator decorator;

    public DecoratedStoryboardBuilder(@NotNull StoryboardBuilder upstream, @NotNull SceneDecorator decorator) {
        Intrinsics.checkNotNullParameter((Object)upstream, (String)"upstream");
        Intrinsics.checkNotNullParameter((Object)decorator, (String)"decorator");
        this.upstream = upstream;
        this.decorator = decorator;
    }

    @Override
    @ComposableInferredTarget(scheme="[0[0]]")
    @NotNull
    public <T> Scene<T> scene(@NotNull List<? extends T> states, @NotNull SceneEnterTransition enterTransition, @NotNull SceneExitTransition exitTransition, @NotNull SceneContent<T> content) {
        Intrinsics.checkNotNullParameter(states, (String)"states");
        Intrinsics.checkNotNullParameter((Object)enterTransition, (String)"enterTransition");
        Intrinsics.checkNotNullParameter((Object)exitTransition, (String)"exitTransition");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        return this.upstream.scene(states, enterTransition, exitTransition, SceneDecoratorKt.decorated(content, this.decorator));
    }
}

