/*
 * Decompiled with CFR 0.152.
 */
package dev.bnorm.storyboard.text;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import dev.bnorm.storyboard.text.TextTag;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.PropertyDelegateProvider;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\rR\u00020\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Ldev/bnorm/storyboard/text/TextTagScope;", "", "tagStart", "", "tagEnd", "<init>", "(CC)V", "regex", "Lkotlin/text/Regex;", "annotationStringTag", "", "_tags", "", "Ldev/bnorm/storyboard/text/TextTagScope$TextTagImpl;", "tags", "", "Ldev/bnorm/storyboard/text/TextTag;", "getTags", "()Ljava/util/Collection;", "tag", "Ldev/bnorm/storyboard/text/TextTagScope$TagProvider;", "description", "data", "extractTags", "Landroidx/compose/ui/text/AnnotatedString;", "string", "TagProvider", "Default", "TextTagImpl", "TagProviderImpl", "storyboard-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTextTag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextTag.kt\ndev/bnorm/storyboard/text/TextTagScope\n+ 2 AnnotatedString.kt\nandroidx/compose/ui/text/AnnotatedStringKt\n*L\n1#1,281:1\n1565#2:282\n*S KotlinDebug\n*F\n+ 1 TextTag.kt\ndev/bnorm/storyboard/text/TextTagScope\n*L\n89#1:282\n*E\n"})
public abstract class TextTagScope {
    private final char tagStart;
    private final char tagEnd;
    @NotNull
    private final Regex regex;
    @NotNull
    private final String annotationStringTag;
    @NotNull
    private final Map<String, TextTagImpl> _tags;
    public static final int $stable = 8;

    public TextTagScope(char tagStart, char tagEnd) {
        this.tagStart = tagStart;
        this.tagEnd = tagEnd;
        this.regex = new Regex(this.tagStart + "(?<id>[^" + this.tagStart + this.tagEnd + "]+)" + this.tagEnd);
        this.annotationStringTag = "" + this.tagStart + this.tagEnd;
        this._tags = new LinkedHashMap();
    }

    @NotNull
    public final Collection<TextTag> getTags() {
        return this._tags.values();
    }

    @NotNull
    public final TagProvider tag(@NotNull String description, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return new TagProviderImpl(description, data);
    }

    public static /* synthetic */ TagProvider tag$default(TextTagScope textTagScope, String string, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tag");
        }
        if ((n & 2) != 0) {
            object = null;
        }
        return textTagScope.tag(string, object);
    }

    @NotNull
    public final AnnotatedString extractTags(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Map starts = new LinkedHashMap();
        AnnotatedString.Builder annotatedString = new AnnotatedString.Builder(0, 1, null);
        int offset = 0;
        int removed = 0;
        for (MatchResult match : Regex.findAll$default((Regex)this.regex, (CharSequence)string, (int)0, (int)2, null)) {
            TextTagImpl tag;
            String string2 = string.substring(offset, match.getRange().getStart());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            annotatedString.append(string2);
            offset = match.getRange().getEndInclusive() + 1;
            String tagId = (String)match.getGroupValues().get(1);
            if (this._tags.get(tagId) == null) {
                throw new IllegalStateException(("unknown tag: " + tagId).toString());
            }
            Integer last = (Integer)starts.remove(tag);
            if (last != null) {
                IntRange range = RangesKt.until((int)last, (int)(match.getRange().getStart() - removed));
                annotatedString.addStringAnnotation(this.annotationStringTag, tag.getId(), range.getStart().intValue(), range.getEndInclusive() + 1);
            } else {
                starts.put(tag, match.getRange().getStart() - removed);
            }
            removed += match.getValue().length();
        }
        if (offset < string.length()) {
            String string3 = string.substring(offset, string.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            annotatedString.append(string3);
        }
        for (Map.Entry entry : starts.entrySet()) {
            TextTag tag = (TextTag)entry.getKey();
            int start = ((Number)entry.getValue()).intValue();
            IntRange range = new IntRange(start - removed, string.length() - removed);
            annotatedString.addStringAnnotation(this.annotationStringTag, tag.getId(), range.getStart().intValue(), range.getEndInclusive() + 1);
        }
        return annotatedString.toAnnotatedString();
    }

    @NotNull
    public final AnnotatedString extractTags(@NotNull AnnotatedString string) {
        AnnotatedString.Builder builder;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        boolean $i$f$buildAnnotatedString = false;
        AnnotatedString.Builder $this$extractTags_u24lambda_u240 = builder = new AnnotatedString.Builder(0, 1, null);
        boolean bl = false;
        $this$extractTags_u24lambda_u240.append(string);
        List ranges = this.extractTags(string.getText()).getStringAnnotations(this.annotationStringTag, 0, $this$extractTags_u24lambda_u240.getLength());
        for (AnnotatedString.Range range : ranges) {
            $this$extractTags_u24lambda_u240.addStringAnnotation(this.annotationStringTag, (String)range.getItem(), range.getStart(), range.getEnd());
        }
        return builder.toAnnotatedString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ldev/bnorm/storyboard/text/TextTagScope$Default;", "Ldev/bnorm/storyboard/text/TextTagScope;", "<init>", "()V", "storyboard-text"})
    @StabilityInferred(parameters=0)
    public static class Default
    extends TextTagScope {
        public static final int $stable = 8;

        public Default() {
            super('\u2995', '\u2996');
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00040\u00030\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Ldev/bnorm/storyboard/text/TextTagScope$TagProvider;", "Lkotlin/properties/PropertyDelegateProvider;", "", "Lkotlin/properties/ReadOnlyProperty;", "Ldev/bnorm/storyboard/text/TextTag;", "storyboard-text"})
    public static interface TagProvider
    extends PropertyDelegateProvider<Object, ReadOnlyProperty<? super Object, ? extends TextTag>> {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/bnorm/storyboard/text/TextTagScope$TagProviderImpl;", "Ldev/bnorm/storyboard/text/TextTagScope$TagProvider;", "description", "", "data", "", "<init>", "(Ldev/bnorm/storyboard/text/TextTagScope;Ljava/lang/String;Ljava/lang/Object;)V", "provideDelegate", "Lkotlin/properties/ReadOnlyProperty;", "Ldev/bnorm/storyboard/text/TextTag;", "thisRef", "property", "Lkotlin/reflect/KProperty;", "storyboard-text"})
    @SourceDebugExtension(value={"SMAP\nTextTag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextTag.kt\ndev/bnorm/storyboard/text/TextTagScope$TagProviderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1#2:282\n*E\n"})
    private final class TagProviderImpl
    implements TagProvider {
        @NotNull
        private final String description;
        @Nullable
        private final Object data;

        public TagProviderImpl(@Nullable String description, Object data) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.description = description;
            this.data = data;
        }

        @NotNull
        public ReadOnlyProperty<Object, TextTag> provideDelegate(@Nullable Object thisRef, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            String id = property.getName();
            boolean bl = !StringsKt.contains$default((CharSequence)id, (char)TextTagScope.this.tagStart, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)id, (char)TextTagScope.this.tagEnd, (boolean)false, (int)2, null);
            TextTagScope textTagScope = TextTagScope.this;
            if (!bl) {
                boolean bl2 = false;
                String string = "name cannot contain '" + textTagScope.tagStart + "' or '" + textTagScope.tagEnd + "': " + id;
                throw new IllegalArgumentException(string.toString());
            }
            TextTagImpl tag = new TextTagImpl(id, this.description, this.data);
            TextTagImpl previous = TextTagScope.this._tags.put(id, tag);
            if (previous != null) {
                throw new IllegalStateException(("tag '" + tag.getId() + "' already exists").toString());
            }
            return (ReadOnlyProperty)new ReadOnlyProperty<Object, TextTag>(tag){
                final /* synthetic */ TextTagImpl $tag;
                {
                    this.$tag = $tag;
                }

                public TextTag getValue(Object thisRef, KProperty<?> property) {
                    Intrinsics.checkNotNullParameter(property, (String)"property");
                    return this.$tag;
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u0011"}, d2={"Ldev/bnorm/storyboard/text/TextTagScope$TextTagImpl;", "Ldev/bnorm/storyboard/text/TextTag;", "id", "", "description", "data", "", "<init>", "(Ldev/bnorm/storyboard/text/TextTagScope;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "getId", "()Ljava/lang/String;", "getDescription", "getData", "()Ljava/lang/Object;", "annotationStringTag", "getAnnotationStringTag", "toString", "storyboard-text"})
    private final class TextTagImpl
    implements TextTag {
        @NotNull
        private final String id;
        @NotNull
        private final String description;
        @Nullable
        private final Object data;

        public TextTagImpl(@NotNull String id, @Nullable String description, Object data) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.id = id;
            this.description = description;
            this.data = data;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getDescription() {
            return this.description;
        }

        @Override
        @Nullable
        public Object getData() {
            return this.data;
        }

        @Override
        @NotNull
        public String getAnnotationStringTag() {
            return TextTagScope.this.annotationStringTag;
        }

        @NotNull
        public String toString() {
            return TextTagScope.this.tagStart + this.getId() + TextTagScope.this.tagEnd;
        }
    }
}

