/*
 * Decompiled with CFR 0.152.
 */
package dev.bnorm.storyboard.text.magic;

import dev.bnorm.storyboard.text.magic.Move;
import dev.bnorm.storyboard.text.magic.MutableSharedText;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u000eJ\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0011\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001f"}, d2={"Ldev/bnorm/storyboard/text/magic/MatchPair;", "", "before", "Ldev/bnorm/storyboard/text/magic/MutableSharedText;", "after", "<init>", "(Ldev/bnorm/storyboard/text/magic/MutableSharedText;Ldev/bnorm/storyboard/text/magic/MutableSharedText;)V", "getBefore", "()Ldev/bnorm/storyboard/text/magic/MutableSharedText;", "getAfter", "move", "direction", "Ldev/bnorm/storyboard/text/magic/Move;", "stopOnLineBreaks", "", "couldAssociate", "unkeyed", "matches", "sequence", "Lkotlin/sequences/Sequence;", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "hashCode", "toString", "", "storyboard-text"})
final class MatchPair
implements Comparable<MatchPair> {
    @NotNull
    private final MutableSharedText before;
    @NotNull
    private final MutableSharedText after;

    public MatchPair(@NotNull MutableSharedText before, @NotNull MutableSharedText after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        this.before = before;
        this.after = after;
    }

    @NotNull
    public final MutableSharedText getBefore() {
        return this.before;
    }

    @NotNull
    public final MutableSharedText getAfter() {
        return this.after;
    }

    @Nullable
    public final MatchPair move(@NotNull Move direction, boolean stopOnLineBreaks) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        MutableSharedText mutableSharedText = this.before.move(direction, stopOnLineBreaks);
        if (mutableSharedText == null) {
            return null;
        }
        MutableSharedText mutableSharedText2 = this.after.move(direction, stopOnLineBreaks);
        if (mutableSharedText2 == null) {
            return null;
        }
        return new MatchPair(mutableSharedText, mutableSharedText2);
    }

    public final boolean couldAssociate() {
        return this.unkeyed() && this.matches();
    }

    public final boolean unkeyed() {
        return this.before.getKey() == null && this.after.getKey() == null;
    }

    public final boolean matches() {
        return Intrinsics.areEqual((Object)this.before.getValue().getText(), (Object)this.after.getValue().getText());
    }

    @NotNull
    public final Sequence<MatchPair> sequence(@NotNull Move direction, boolean stopOnLineBreaks) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        return SequencesKt.generateSequence((Object)this, arg_0 -> MatchPair.sequence$lambda$0(direction, stopOnLineBreaks, arg_0));
    }

    @Override
    public int compareTo(@NotNull MatchPair other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.after.compareTo(other.after) < 0 && this.before.compareTo(other.before) < 0) {
            n = -1;
        } else if (this.after.compareTo(other.after) > 0 && this.before.compareTo(other.before) > 0) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)this.after, (Object)other.after) && Intrinsics.areEqual((Object)this.before, (Object)other.before)) {
            n = 0;
        } else {
            throw new IllegalStateException("!".toString());
        }
        return n;
    }

    @NotNull
    public final MutableSharedText component1() {
        return this.before;
    }

    @NotNull
    public final MutableSharedText component2() {
        return this.after;
    }

    @NotNull
    public final MatchPair copy(@NotNull MutableSharedText before, @NotNull MutableSharedText after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return new MatchPair(before, after);
    }

    public static /* synthetic */ MatchPair copy$default(MatchPair matchPair, MutableSharedText mutableSharedText, MutableSharedText mutableSharedText2, int n, Object object) {
        if ((n & 1) != 0) {
            mutableSharedText = matchPair.before;
        }
        if ((n & 2) != 0) {
            mutableSharedText2 = matchPair.after;
        }
        return matchPair.copy(mutableSharedText, mutableSharedText2);
    }

    @NotNull
    public String toString() {
        return "MatchPair(before=" + this.before + ", after=" + this.after + ")";
    }

    public int hashCode() {
        int result = this.before.hashCode();
        result = result * 31 + this.after.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MatchPair)) {
            return false;
        }
        MatchPair matchPair = (MatchPair)other;
        if (!Intrinsics.areEqual((Object)this.before, (Object)matchPair.before)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.after, (Object)matchPair.after);
    }

    private static final MatchPair sequence$lambda$0(Move $direction, boolean $stopOnLineBreaks, MatchPair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.move($direction, $stopOnLineBreaks);
    }
}

