package dev.kikugie.commons.text

/**
 * Checks if [this] character matches pattern `[a-zA-Z]`.
 * @sample dev.kikugie.commons_samples.Chars.isEnglishLetter
 */
public fun Char.isEnglishLetter(): Boolean = this in 'a'..'z' || this in 'A'..'Z'
/**
 * Checks if [this] character matches pattern `[a-zA-Z0-9]`.
 * @sample dev.kikugie.commons_samples.Chars.isEnglishLetterOrDigit
 */
public fun Char.isEnglishLetterOrDigit(): Boolean = isEnglishLetter() || isDigit()
