package dev.kikugie.commons_samples

import dev.kikugie.commons.then
import kotlin.test.assertEquals
import kotlin.test.assertFailsWith

private class ControlFlow {
    @Sample
    fun then() {
        fun incrementChecked(value: Int) = require(value < Int.MAX_VALUE) then value + 1

        assertEquals(2, incrementChecked(1))
        assertFailsWith<IllegalArgumentException> { incrementChecked(Int.MAX_VALUE) }
    }
}