package dev.kikugie.commons_samples

import dev.kikugie.commons.ranges.extend
import dev.kikugie.commons.ranges.shl
import dev.kikugie.commons.ranges.shr
import dev.kikugie.commons.ranges.contains
import dev.kikugie.commons.ranges.overlaps
import dev.kikugie.commons.ranges.cross
import dev.kikugie.commons.ranges.extend
import dev.kikugie.commons.ranges.merge
import kotlin.test.assertEquals
import kotlin.test.assertFalse
import kotlin.test.assertTrue

private class Ranges {
    @Sample
    fun extend() {
        assertEquals(2..5, 2 extend 3)

        // Unchecked
        assertEquals(2..-1, 2 extend -3)
        assertEquals(2_147_483_647..-2_147_483_640, Int.MAX_VALUE extend 8)
    }

    @Sample
    fun shiftRight() {
        assertEquals(4..6, 1..3 shr 3)

        // Unchecked
        assertEquals(0..2, 1..3 shr -1)
        assertEquals(2_147_483_646..2_147_483_644, (Int.MAX_VALUE - 2)..Int.MAX_VALUE shr 2)
    }

    @Sample
    fun shiftLeft() {
        assertEquals(1..3, 4..6 shl 3)

        // Unchecked
        assertEquals(7..9, 4..6 shl -3)
        assertEquals(2_147_483_644..2_147_483_646, (Int.MIN_VALUE - 2..Int.MIN_VALUE) shl 2)
    }

    @Sample
    fun crossRange() {
        assertEquals(2..3, 1..3 cross 2..4)
        assertEquals(IntRange.EMPTY, 1..3 cross 5..9)
    }

    @Sample
    fun extendRange() {
        assertEquals(1..9, 1..3 extend 5..9)
    }

    @Sample
    fun mergeRange() {
        assertEquals(1..4, 1..3 merge 2..4)
        assertEquals(IntRange.EMPTY, 1..3 merge 5..9)
    }

    @Sample
    fun overlaps() {
        assertTrue(1..3 overlaps 2..4)
        assertFalse(1..3 overlaps 5..9)
    }

    @Sample
    fun contains() {
        assertTrue(1..3 in 1..3)
        assertTrue(1..3 !in 5..9)
        assertFalse(1..3 in 0..2)
    }
}