package dev.kikugie.commons_samples

import dev.kikugie.commons.serialization.IntRangeSerializer
import kotlinx.serialization.json.Json
import kotlinx.serialization.modules.SerializersModule
import kotlin.test.assertEquals


private class Serialization {
    val Json = Json {
        serializersModule = SerializersModule {
            contextual(IntRange::class, IntRangeSerializer)
            include(serializersModule)
        }
    }

    @Sample
    fun rangeSerialization() {
        assertEquals("\"1..3\"", Json.encodeToString(1..3))
        assertEquals(1..3, Json.decodeFromString("\"1..3\""))
        assertEquals(1..2, Json.decodeFromString("\"1..<3\""))
    }
}