package dev.kikugie.commons_samples

import dev.kikugie.commons.text.countMatching
import dev.kikugie.commons.text.countWhile
import dev.kikugie.commons.text.getOrDefault
import dev.kikugie.commons.text.isEnglishLetter
import dev.kikugie.commons.text.isEnglishLetterOrDigit
import dev.kikugie.commons.text.reverseView
import kotlin.test.assertEquals
import kotlin.test.assertFalse
import kotlin.test.assertTrue

private class Strings {
    @Sample
    fun getOrDefault() {
        assertEquals('b', "abc".getOrDefault(1))
        assertEquals(' ', "abc".getOrDefault(4))
        assertEquals('?', "abc".getOrDefault(4, '?'))
    }

    @Sample
    fun countMatching() {
        assertEquals(0, "...oops".countMatching('o'))
        assertEquals(3, "...oops".countMatching('.'))
        assertEquals(5, "...oops".countMatching('.', 'o'))
        assertEquals(3, "...oops".countMatching(start = 3, end = 6, 'o', 'p', 's'))
    }

    @Sample
    fun countWhile() {
        assertEquals(0, "\n hello!".countWhile(Char::isLetter))
        assertEquals(2, "\n hello!".countWhile(Char::isWhitespace))
        assertEquals(5, "\n hello!".countWhile(start = 2, end = 7, Char::isLetter))
    }

    @Sample @Suppress("ReplaceGetOrSet")
    fun reverseView() {
        assertEquals('c', "abc".reverseView().get(0))
        assertEquals("cba", "abc".reverseView().toString())
        assertEquals("row", "hello world".reverseView().subSequence(2, 5))
    }
}

private class Chars {
    @Sample
    fun isEnglishLetter() {
        assertTrue('a'.isEnglishLetter())
        assertFalse('1'.isEnglishLetter())
        assertFalse('ッ'.isEnglishLetter())
    }

    fun isEnglishLetterOrDigit() {
        assertTrue('1'.isEnglishLetterOrDigit())
        assertFalse(' '.isEnglishLetterOrDigit())
    }
}