@file:Suppress("NOTHING_TO_INLINE", "UNCHECKED_CAST")
package dev.kikugie.commons.collections

import dev.kikugie.commons.applyIf
/**Applies [action] to the receiver if it's not empty.*/
public inline fun <T> Array<out T>.ifNotEmpty(action: Array<out T>.() -> Unit): Array<out T> =
    applyIf(isNotEmpty(), action)

/**Applies [action] to the receiver if it's not empty.*/
public inline fun ByteArray.ifNotEmpty(action: ByteArray.() -> Unit): ByteArray =
    applyIf(isNotEmpty(), action)

/**Applies [action] to the receiver if it's not empty.*/
public inline fun CharArray.ifNotEmpty(action: CharArray.() -> Unit): CharArray =
    applyIf(isNotEmpty(), action)

/**Applies [action] to the receiver if it's not empty.*/
public inline fun ShortArray.ifNotEmpty(action: ShortArray.() -> Unit): ShortArray =
    applyIf(isNotEmpty(), action)

/**Applies [action] to the receiver if it's not empty.*/
public inline fun IntArray.ifNotEmpty(action: IntArray.() -> Unit): IntArray =
    applyIf(isNotEmpty(), action)

/**Applies [action] to the receiver if it's not empty.*/
public inline fun LongArray.ifNotEmpty(action: LongArray.() -> Unit): LongArray =
    applyIf(isNotEmpty(), action)

/**Applies [action] to the receiver if it's not empty.*/
public inline fun FloatArray.ifNotEmpty(action: FloatArray.() -> Unit): FloatArray =
    applyIf(isNotEmpty(), action)

/**Applies [action] to the receiver if it's not empty.*/
public inline fun DoubleArray.ifNotEmpty(action: DoubleArray.() -> Unit): DoubleArray =
    applyIf(isNotEmpty(), action)

/**Applies [action] to the receiver if it's not empty.*/
public inline fun BooleanArray.ifNotEmpty(action: BooleanArray.() -> Unit): BooleanArray =
    applyIf(isNotEmpty(), action)

/**Returns an element at the given [index] or the [default] if the [index] is out of bounds.*/
public inline fun <T> Array<out T>.getOrDefault(index: Int, default: T): T =
    getOrElse(index) { default }

/**Returns an element at the given [index] or the [default] if the [index] is out of bounds.*/
public inline fun ByteArray.getOrDefault(index: Int, default: Byte): Byte =
    getOrElse(index) { default }

/**Returns an element at the given [index] or the [default] if the [index] is out of bounds.*/
public inline fun CharArray.getOrDefault(index: Int, default: Char): Char =
    getOrElse(index) { default }

/**Returns an element at the given [index] or the [default] if the [index] is out of bounds.*/
public inline fun ShortArray.getOrDefault(index: Int, default: Short): Short =
    getOrElse(index) { default }

/**Returns an element at the given [index] or the [default] if the [index] is out of bounds.*/
public inline fun IntArray.getOrDefault(index: Int, default: Int): Int =
    getOrElse(index) { default }

/**Returns an element at the given [index] or the [default] if the [index] is out of bounds.*/
public inline fun LongArray.getOrDefault(index: Int, default: Long): Long =
    getOrElse(index) { default }

/**Returns an element at the given [index] or the [default] if the [index] is out of bounds.*/
public inline fun FloatArray.getOrDefault(index: Int, default: Float): Float =
    getOrElse(index) { default }

/**Returns an element at the given [index] or the [default] if the [index] is out of bounds.*/
public inline fun DoubleArray.getOrDefault(index: Int, default: Double): Double =
    getOrElse(index) { default }

/**Returns an element at the given [index] or the [default] if the [index] is out of bounds.*/
public inline fun BooleanArray.getOrDefault(index: Int, default: Boolean): Boolean =
    getOrElse(index) { default }

/**Returns an element at the given [index] or throws [IndexOutOfBoundsException] with the [message] if the [index] is out of bounds.*/
public inline fun <T> Array<out T>.getOrThrow(index: Int, message: Array<out T>.(Int) -> String): T =
    getOrElse(index) { throw IndexOutOfBoundsException(message(index)) }

/**Returns an element at the given [index] or throws [IndexOutOfBoundsException] with the [message] if the [index] is out of bounds.*/
public inline fun ByteArray.getOrThrow(index: Int, message: ByteArray.(Int) -> String): Byte =
    getOrElse(index) { throw IndexOutOfBoundsException(message(index)) }

/**Returns an element at the given [index] or throws [IndexOutOfBoundsException] with the [message] if the [index] is out of bounds.*/
public inline fun CharArray.getOrThrow(index: Int, message: CharArray.(Int) -> String): Char =
    getOrElse(index) { throw IndexOutOfBoundsException(message(index)) }

/**Returns an element at the given [index] or throws [IndexOutOfBoundsException] with the [message] if the [index] is out of bounds.*/
public inline fun ShortArray.getOrThrow(index: Int, message: ShortArray.(Int) -> String): Short =
    getOrElse(index) { throw IndexOutOfBoundsException(message(index)) }

/**Returns an element at the given [index] or throws [IndexOutOfBoundsException] with the [message] if the [index] is out of bounds.*/
public inline fun IntArray.getOrThrow(index: Int, message: IntArray.(Int) -> String): Int =
    getOrElse(index) { throw IndexOutOfBoundsException(message(index)) }

/**Returns an element at the given [index] or throws [IndexOutOfBoundsException] with the [message] if the [index] is out of bounds.*/
public inline fun LongArray.getOrThrow(index: Int, message: LongArray.(Int) -> String): Long =
    getOrElse(index) { throw IndexOutOfBoundsException(message(index)) }

/**Returns an element at the given [index] or throws [IndexOutOfBoundsException] with the [message] if the [index] is out of bounds.*/
public inline fun FloatArray.getOrThrow(index: Int, message: FloatArray.(Int) -> String): Float =
    getOrElse(index) { throw IndexOutOfBoundsException(message(index)) }

/**Returns an element at the given [index] or throws [IndexOutOfBoundsException] with the [message] if the [index] is out of bounds.*/
public inline fun DoubleArray.getOrThrow(index: Int, message: DoubleArray.(Int) -> String): Double =
    getOrElse(index) { throw IndexOutOfBoundsException(message(index)) }

/**Returns an element at the given [index] or throws [IndexOutOfBoundsException] with the [message] if the [index] is out of bounds.*/
public inline fun BooleanArray.getOrThrow(index: Int, message: BooleanArray.(Int) -> String): Boolean =
    getOrElse(index) { throw IndexOutOfBoundsException(message(index)) }

/**Returns the [Result] of [Array.get] call.*/
public inline fun <T> Array<out T>.getResult(index: Int): Result<T> =
    runCatching { get(index) }

/**Returns the [Result] of [ByteArray.get] call.*/
public inline fun ByteArray.getResult(index: Int): Result<Byte> =
    runCatching { get(index) }

/**Returns the [Result] of [CharArray.get] call.*/
public inline fun CharArray.getResult(index: Int): Result<Char> =
    runCatching { get(index) }

/**Returns the [Result] of [ShortArray.get] call.*/
public inline fun ShortArray.getResult(index: Int): Result<Short> =
    runCatching { get(index) }

/**Returns the [Result] of [IntArray.get] call.*/
public inline fun IntArray.getResult(index: Int): Result<Int> =
    runCatching { get(index) }

/**Returns the [Result] of [LongArray.get] call.*/
public inline fun LongArray.getResult(index: Int): Result<Long> =
    runCatching { get(index) }

/**Returns the [Result] of [FloatArray.get] call.*/
public inline fun FloatArray.getResult(index: Int): Result<Float> =
    runCatching { get(index) }

/**Returns the [Result] of [DoubleArray.get] call.*/
public inline fun DoubleArray.getResult(index: Int): Result<Double> =
    runCatching { get(index) }

/**Returns the [Result] of [BooleanArray.get] call.*/
public inline fun BooleanArray.getResult(index: Int): Result<Boolean> =
    runCatching { get(index) }

/**Returns the [Result] of [Array.getOrThrow] call.*/
public inline fun <T> Array<out T>.getResult(index: Int, message: Array<out T>.(Int) -> String): Result<T> =
    runCatching { getOrThrow(index, message) }

/**Returns the [Result] of [ByteArray.getOrThrow] call.*/
public inline fun ByteArray.getResult(index: Int, message: ByteArray.(Int) -> String): Result<Byte> =
    runCatching { getOrThrow(index, message) }

/**Returns the [Result] of [CharArray.getOrThrow] call.*/
public inline fun CharArray.getResult(index: Int, message: CharArray.(Int) -> String): Result<Char> =
    runCatching { getOrThrow(index, message) }

/**Returns the [Result] of [ShortArray.getOrThrow] call.*/
public inline fun ShortArray.getResult(index: Int, message: ShortArray.(Int) -> String): Result<Short> =
    runCatching { getOrThrow(index, message) }

/**Returns the [Result] of [IntArray.getOrThrow] call.*/
public inline fun IntArray.getResult(index: Int, message: IntArray.(Int) -> String): Result<Int> =
    runCatching { getOrThrow(index, message) }

/**Returns the [Result] of [LongArray.getOrThrow] call.*/
public inline fun LongArray.getResult(index: Int, message: LongArray.(Int) -> String): Result<Long> =
    runCatching { getOrThrow(index, message) }

/**Returns the [Result] of [FloatArray.getOrThrow] call.*/
public inline fun FloatArray.getResult(index: Int, message: FloatArray.(Int) -> String): Result<Float> =
    runCatching { getOrThrow(index, message) }

/**Returns the [Result] of [DoubleArray.getOrThrow] call.*/
public inline fun DoubleArray.getResult(index: Int, message: DoubleArray.(Int) -> String): Result<Double> =
    runCatching { getOrThrow(index, message) }

/**Returns the [Result] of [BooleanArray.getOrThrow] call.*/
public inline fun BooleanArray.getResult(index: Int, message: BooleanArray.(Int) -> String): Result<Boolean> =
    runCatching { getOrThrow(index, message) }

/**Returns the first [T] element that satisfies the [check] or `null` if nothing was found.*/
public inline fun <reified T : Any> Array<*>.findIsInstance(check: (T) -> Boolean = { true }): T? {
    for (it in this) if (it is T && check(it)) return it
    return null
}

/**Returns the first [T] element that satisfies the [check] or throws [NoSuchElementException] if nothing was found.*/
public inline fun <reified T : Any> Array<*>.firstIsInstance(check: (T) -> Boolean = { true }): T {
    for (it in this) if (it is T && check(it)) return it
    throw NoSuchElementException("No element found")
}

/**Returns the first non-null element or `null` otherwise.*/
public fun <T : Any> Array<out T>.firstNotNullOrNull(): T? =
    firstNotNullOfOrNull { it }

/**Returns the first non-null element or `null` otherwise.*/
public fun <T : Any> Array<out T>.firstNotNull(): T =
    notNullElement(firstNotNullOrNull()) { "No non-null element was found" }

/**Returns the last non-null element produced by [transform] function or `null` otherwise.
* The element is found by iterating the collection in reverse order.*/
public inline fun <T, R : Any> Array<out T>.lastNotNullOfOrNull(transform: (T) -> R?): R? {
    for (index in size - 1 downTo 0) {
        val element = transform(get(index))
        if (element != null) return element
    }
    return null
}

/**Returns the last non-null element produced by [transform] function or throws [NoSuchElementException] otherwise.*/
public inline fun <T, R : Any> Array<out T>.lastNotNullOf(transform: (T) -> R?): R =
    notNullElement(lastNotNullOfOrNull(transform)) { "No element was transformed to a non-null value." }

/**Returns the last non-null element or `null` otherwise.*/
public fun <T : Any> Array<out T>.lastNotNullOrNull(): T? =
    lastNotNullOfOrNull { it }

/**Returns the last non-null element or throws [NoSuchElementException] otherwise.*/
public fun <T : Any> Array<out T>.lastNotNull(): T =
    notNullElement(lastNotNullOrNull()) { "No non-null element was found in the list" }

