package dev.kikugie.commons.collections

/**
 * Pretty-prints the provided collection in JSON array style.
 * @sample dev.kikugie.commons_samples.Collections.collectionPresentation
 * @see joinToString
 */
public fun <T> Collection<T>.present(limit: Int = -1): String =
    joinToString(prefix = "[", postfix = "]", limit = limit)

/**
 * Pretty-prints the provided collection in JSON array style.
 * @sample dev.kikugie.commons_samples.Collections.collectionPresentation
 * @see joinToString
 */
public fun <T> Collection<T>.present(limit: Int = -1, format: (T) -> CharSequence): String =
    joinToString(prefix = "[", postfix = "]", limit = limit, transform = format)

/**
 * Pretty-prints the provided map in JSON dictionary style.
 * @sample dev.kikugie.commons_samples.Collections.mapPresentation
 * @see joinToString
 */
public fun <K, V> Map<K, V>.present(limit: Int = -1): String =
    entries.joinToString(prefix = "{", postfix = "}", limit = limit) { (k, v) -> "$k: $v" }

/**
 * Pretty-prints the provided map in JSON dictionary style.
 * @sample dev.kikugie.commons_samples.Collections.mapPresentation
 * @see joinToString
 */
public fun <K, V> Map<K, V>.present(limit: Int = -1, format: (k: K, v: V) -> CharSequence): String =
    entries.joinToString(prefix = "{", postfix = "}", limit = limit) { (k, v) -> format(k, v) }