@file:Suppress("NOTHING_TO_INLINE", "UNCHECKED_CAST")
package dev.kikugie.commons.collections

import dev.kikugie.commons.applyIf
/**Returns the first [T] element that satisfies the [check] or `null` if nothing was found.*/
public inline fun <reified T : Any> Sequence<*>.findIsInstance(check: (T) -> Boolean = { true }): T? {
    for (it in this) if (it is T && check(it)) return it
    return null
}

/**Returns the first [T] element that satisfies the [check] or throws [NoSuchElementException] if nothing was found.*/
public inline fun <reified T : Any> Sequence<*>.firstIsInstance(check: (T) -> Boolean = { true }): T {
    for (it in this) if (it is T && check(it)) return it
    throw NoSuchElementException("No element found")
}

/**Returns the first non-null element or `null` otherwise.*/
public fun <T : Any> Sequence<T>.firstNotNullOrNull(): T? =
    firstNotNullOfOrNull { it }

/**Returns the first non-null element or `null` otherwise.*/
public fun <T : Any> Sequence<T>.firstNotNull(): T =
    notNullElement(firstNotNullOrNull()) { "No non-null element was found" }

/**Returns the last non-null element produced by [transform] function or `null` otherwise.
* The element is found by iterating through all elements, capturing the last matching one.*/
public inline fun <T, R : Any> Sequence<T>.lastNotNullOfOrNull(transform: (T) -> R?): R? {
    var last: R? = null
    for (element in this) {
        val transformed = transform(element)
        if (transformed != null) last = transformed
    }
    return last
}

/**Returns the last non-null element produced by [transform] function or throws [NoSuchElementException] otherwise.*/
public inline fun <T, R : Any> Sequence<T>.lastNotNullOf(transform: (T) -> R?): R =
    notNullElement(lastNotNullOfOrNull(transform)) { "No element was transformed to a non-null value." }

/**Returns the last non-null element or `null` otherwise.*/
public fun <T : Any> Sequence<T>.lastNotNullOrNull(): T? =
    lastNotNullOfOrNull { it }

/**Returns the last non-null element or throws [NoSuchElementException] otherwise.*/
public fun <T : Any> Sequence<T>.lastNotNull(): T =
    notNullElement(lastNotNullOrNull()) { "No non-null element was found in the list" }

