package dev.kikugie.commons.ranges

public inline fun bind(pos: Int, range: IntRange, message: () -> String) {
    if (pos !in range) throw IndexOutOfBoundsException(message())
}

/**
 * Checks if [this] and the [other] range have an overlapping segment.
 * @sample dev.kikugie.commons_samples.Ranges.overlaps
 */
public infix fun <T : Comparable<T>> ClosedRange<T>.overlaps(other: ClosedRange<T>): Boolean =
    other.start in this || other.endInclusive in this

/**
 * Checks if both endpoints of the [other] range are inside of [this] one.
 * @sample dev.kikugie.commons_samples.Ranges.contains
 */
public operator fun <T : Comparable<T>> ClosedRange<T>.contains(other: ClosedRange<T>): Boolean =
    other.start in this && other.endInclusive in this
