
@file:Suppress("NOTHING_TO_INLINE", "UNCHECKED_CAST")
package dev.kikugie.commons.ranges

import kotlin.math.max
import kotlin.math.min

/**Creates a range starting at [this], spanning the provided [length]. The result is unchecked.*/
public inline infix fun Int.extend(length: Int): IntRange = this..(this + length)

/**Shifts [this] range [n] steps to the left. The result is unchecked.*/
public inline infix fun IntRange.shl(n: Int): IntRange = (first - n)..(last - n)

/**Shifts [this] range [n] steps to the right. The result is unchecked.*/
public inline infix fun IntRange.shr(n: Int): IntRange = (first + n)..(last + n)

/**Creates a union of [this] and the [other] range,
 * **covering all values between them**.*/
public infix fun IntRange.extend(other: IntRange): IntRange =
    min(first, other.first)..max(last, other.last)

/**Creates a union of [this] and the [other] range **if they overlap**,
 * otherwise returns [LongRange.EMPTY].*/
public infix fun IntRange.merge(other: IntRange): IntRange =
    if (this.overlaps(other)) extend(other)
    else IntRange.EMPTY

/**Creates an intersection between [this] and the [other] range,
 * returning [LongRange.EMPTY] if there's no overlap.*/
public infix fun IntRange.cross(other: IntRange): IntRange =
    if (this.overlaps(other)) max(first, other.first)..min(last, other.last)
    else IntRange.EMPTY

