package dev.kikugie.commons_samples

import dev.kikugie.commons.collections.FixedQueue
import dev.kikugie.commons.collections.present
import kotlin.test.assertEquals
import kotlin.test.assertFailsWith

private class Collections {
    @Sample
    fun fixedQueue() {
        val queue = FixedQueue<Int>(4)
        queue += listOf(1, 2, 3, 4)

        assertFailsWith<IndexOutOfBoundsException> { queue += 5 }
        assertFailsWith<UnsupportedOperationException> { queue -= 3 }
        assertEquals(1, queue.remove())
    }

    @Sample
    fun collectionPresentation() {
        val items: Collection<Int> = listOf(1, 2, 3)

        assertEquals("[1, 2, 3]", items.present())
        assertEquals("[1, ...]", items.present(limit = 1))
        assertEquals("['1', '2', '3']", items.present { "'$it'" })
    }

    @Sample
    fun mapPresentation() {
        val entries: Map<String, Int> = mapOf("a" to 1, "b" to 2, "c" to 3)

        assertEquals("{a: 1, b: 2, c: 3}", entries.present())
        assertEquals("{a: 1, ...}", entries.present(limit = 1))
        assertEquals("{'a' = 0b1, 'b' = 0b10, 'c' = 0b11}", entries.present { k, v -> "'$k' = 0b${v.toString(2)}" })
    }
}