package dev.kikugie.commons_samples

import dev.kikugie.commons.result.*
import kotlin.test.assertIs
import kotlin.test.assertTrue

private class Results {
    @Sample
    fun notNullResult() {
        fun getNullable(str: String): String? =
            if (str == "null") null else str

        assertTrue(notNullResult(getNullable("any")).isSuccess)
        assertTrue(notNullResult(getNullable("null")).isFailure)
    }

    @Sample
    fun mapException() {
        fun inverse(num: Int): Result<Int> =
            runCatching { 1 / num }

        var result = inverse(0)
        assertIs<ArithmeticException>(result.exceptionOrNull())

        result = result.mapException {
            IllegalArgumentException("Zero is not a valid divisor")
        }
        assertIs<IllegalArgumentException>(result.exceptionOrNull())
    }

    @Sample
    fun mapResult() {
        fun example(fail: Boolean): Result<String> = runCatching {
            if (fail) throw IllegalStateException("Something went wrong")
            "Hello world!"
        }

        val failed = runCatching { example(false) }.mapResult { example(true) }
        assertIs<IllegalStateException>(failed.exceptionOrNull())

        val succeeded = runCatching { example(false) }.mapResult { example(false) }
        assertIs<String>(succeeded.getOrNull())
    }
}