/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.commons_samples;

import dev.kikugie.commons.collections.FixedQueue;
import dev.kikugie.commons.collections.PresentationKt;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.test.AssertionsKt;
import kotlin.text.CharsKt;
import org.junit.jupiter.api.Test;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007\u00a8\u0006\b"}, d2={"Ldev/kikugie/commons_samples/Collections;", "", "<init>", "()V", "fixedQueue", "", "collectionPresentation", "mapPresentation", "KikuGie's Commons"})
@SourceDebugExtension(value={"SMAP\nCollections.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Collections.kt\ndev/kikugie/commons_samples/Collections\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
final class Collections {
    @Test
    public final void fixedQueue() {
        Object object;
        Object $i$a$-assertFailsWith$default-Collections$fixedQueue$32;
        FixedQueue queue = new FixedQueue(4);
        Collection collection = queue;
        Object object2 = new Integer[]{1, 2, 3, 4};
        CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])object2));
        collection = null;
        object2 = collection;
        KClass kClass = Reflection.getOrCreateKotlinClass(IndexOutOfBoundsException.class);
        try {
            boolean $i$a$-assertFailsWith$default-Collections$fixedQueue$32 = false;
            ((Collection)queue).add(5);
            $i$a$-assertFailsWith$default-Collections$fixedQueue$32 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $i$a$-assertFailsWith$default-Collections$fixedQueue$32 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object object3 = $i$a$-assertFailsWith$default-Collections$fixedQueue$32;
        AssertionsKt.checkResultIsFailure((KClass)kClass, (String)object2, (Object)object3);
        collection = null;
        object2 = collection;
        kClass = Reflection.getOrCreateKotlinClass(UnsupportedOperationException.class);
        try {
            boolean bl = false;
            ((Collection)queue).remove(3);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = object;
        AssertionsKt.checkResultIsFailure((KClass)kClass, (String)object2, (Object)object3);
        AssertionsKt.assertEquals$default((Object)1, queue.remove(), null, (int)4, null);
    }

    @Test
    public final void collectionPresentation() {
        Object[] objectArray = new Integer[]{1, 2, 3};
        Collection items = CollectionsKt.listOf((Object[])objectArray);
        AssertionsKt.assertEquals$default((Object)"[1, 2, 3]", (Object)PresentationKt.present$default(items, 0, 1, null), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"[1, ...]", (Object)PresentationKt.present(items, 1), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"['1', '2', '3']", (Object)PresentationKt.present$default(items, 0, Collections::collectionPresentation$lambda$2, 1, null), null, (int)4, null);
    }

    @Test
    public final void mapPresentation() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"a", (Object)1), TuplesKt.to((Object)"b", (Object)2), TuplesKt.to((Object)"c", (Object)3)};
        Map entries = MapsKt.mapOf((Pair[])pairArray);
        AssertionsKt.assertEquals$default((Object)"{a: 1, b: 2, c: 3}", (Object)PresentationKt.present$default(entries, 0, 1, null), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"{a: 1, ...}", (Object)PresentationKt.present(entries, 1), null, (int)4, null);
        AssertionsKt.assertEquals$default((Object)"{'a' = 0b1, 'b' = 0b10, 'c' = 0b11}", (Object)PresentationKt.present$default(entries, 0, Collections::mapPresentation$lambda$3, 1, null), null, (int)4, null);
    }

    private static final CharSequence collectionPresentation$lambda$2(int it) {
        return "'" + it + "'";
    }

    private static final CharSequence mapPresentation$lambda$3(String k, int v) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        String string = Integer.toString(v, CharsKt.checkRadix((int)2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "'" + k + "' = 0b" + string;
    }
}

