/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.commons.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001,B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00172\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0015\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\"\u001a\u00020\u00172\u0006\u0010!\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\r\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u000f\u0010%\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010$J\r\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u000f\u0010&\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u0016\u0010'\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0016J\u0013\u0010(\u001a\f0)R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0096\u0002J\u0015\u0010#\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00028\u0000H\u0017\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010*\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0017J\u0016\u0010+\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001dH\u0017R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006-"}, d2={"Ldev/kikugie/commons/collections/FixedQueue;", "T", "Ljava/util/Queue;", "capacity", "", "<init>", "(I)V", "getCapacity", "()I", "array", "", "", "[Ljava/lang/Object;", "head", "value", "size", "getSize", "get", "index", "(I)Ljava/lang/Object;", "toString", "", "isEmpty", "", "contains", "element", "(Ljava/lang/Object;)Z", "containsAll", "elements", "", "clear", "", "add", "e", "offer", "remove", "()Ljava/lang/Object;", "poll", "peek", "addAll", "iterator", "Ldev/kikugie/commons/collections/FixedQueue$FixedQueueIterator;", "removeAll", "retainAll", "FixedQueueIterator", "KikuGie's Commons"})
@SourceDebugExtension(value={"SMAP\nFixedQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedQueue.kt\ndev/kikugie/commons/collections/FixedQueue\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1740#2,3:125\n1869#2,2:128\n*S KotlinDebug\n*F\n+ 1 FixedQueue.kt\ndev/kikugie/commons/collections/FixedQueue\n*L\n41#1:125,3\n92#1:128,2\n*E\n"})
public final class FixedQueue<T>
implements Queue<T> {
    private final int capacity;
    @NotNull
    private final Object[] array;
    private int head;
    private int size;

    public FixedQueue(int capacity) {
        this.capacity = capacity;
        this.array = new Object[this.capacity];
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public int getSize() {
        return this.size;
    }

    public final T get(int index) {
        if (!(0 <= index ? index < this.size() : false)) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for length " + this.size());
        }
        return (T)this.array[(this.head + index) % this.capacity];
    }

    @NotNull
    public String toString() {
        int n = this.size();
        String string = Arrays.toString(this.array);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "FixedQueue(size=" + n + ", capacity=" + this.capacity + ", values=" + string + ")";
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return ArraysKt.contains((Object[])this.array, (Object)element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object p0 = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (this.contains(p0)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void clear() {
        ArraysKt.fill$default((Object[])this.array, null, (int)0, (int)0, (int)6, null);
        this.head = 0;
        this.size = 0;
    }

    @Override
    public boolean add(T e) {
        boolean bl;
        if (this.size() >= this.capacity) {
            throw new IndexOutOfBoundsException("Queue is full");
        }
        boolean it = bl = true;
        boolean bl2 = false;
        int n = this.size();
        this.size = n + 1;
        this.array[(this.head + n) % this.capacity] = e;
        return bl;
    }

    @Override
    public boolean offer(T e) {
        boolean bl;
        if (this.size() >= this.capacity) {
            bl = false;
        } else {
            boolean bl2;
            boolean it = bl2 = true;
            boolean bl3 = false;
            int n = this.size();
            this.size = n + 1;
            this.array[(this.head + n) % this.capacity] = e;
            bl = bl2;
        }
        return bl;
    }

    @Override
    public T remove() {
        Object object;
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue is empty");
        }
        Object it = object = this.array[this.head];
        boolean bl = false;
        this.array[this.head] = null;
        this.head = (this.head + 1) % this.capacity;
        this.size = this.size() + -1;
        this.size();
        return (T)object;
    }

    @Override
    @Nullable
    public T poll() {
        Object object;
        if (this.isEmpty()) {
            object = null;
        } else {
            Object object2;
            Object it = object2 = this.array[this.head];
            boolean bl = false;
            this.array[this.head] = null;
            this.head = (this.head + 1) % this.capacity;
            this.size = this.size() + -1;
            this.size();
            object = object2;
        }
        return (T)object;
    }

    @Override
    public T element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Queue is empty");
        }
        return (T)this.array[this.head];
    }

    @Override
    @Nullable
    public T peek() {
        return (T)(this.isEmpty() ? null : this.array[this.head]);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        boolean bl;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean it = bl = true;
        boolean bl2 = false;
        if (this.size() + elements.size() > this.capacity) {
            throw new IndexOutOfBoundsException("Not enough space in queue");
        }
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object p0 = element$iv = iterator.next();
            boolean bl3 = false;
            this.add((T)p0);
        }
        return bl;
    }

    @NotNull
    public FixedQueueIterator iterator() {
        return new FixedQueueIterator();
    }

    @Override
    @Deprecated(message="Unsupported operation", level=DeprecationLevel.ERROR)
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Removal of arbitrary elements is not supported");
    }

    @Override
    @Deprecated(message="Unsupported operation", level=DeprecationLevel.ERROR)
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        throw new UnsupportedOperationException("Removal of arbitrary elements is not supported");
    }

    @Override
    @Deprecated(message="Unsupported operation", level=DeprecationLevel.ERROR)
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        throw new UnsupportedOperationException("Removal of arbitrary elements is not supported");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0007H\u0096\u0002J\u000e\u0010\b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/kikugie/commons/collections/FixedQueue$FixedQueueIterator;", "", "<init>", "(Ldev/kikugie/commons/collections/FixedQueue;)V", "index", "", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "KikuGie's Commons"})
    public final class FixedQueueIterator
    implements Iterator<T>,
    KMutableIterator {
        private int index;

        @Override
        public boolean hasNext() {
            return !((Collection)FixedQueue.this).isEmpty() && this.index < FixedQueue.this.size();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Finished iterating queue");
            }
            int n = this.index;
            this.index = n + 1;
            return FixedQueue.this.array[(FixedQueue.this.head + n) % FixedQueue.this.getCapacity()];
        }

        @Override
        @Deprecated(message="Unsupported operation", level=DeprecationLevel.ERROR)
        public void remove() {
            throw new UnsupportedOperationException("Removal of arbitrary elements is not supported");
        }
    }
}

