/*
 * Decompiled with CFR 0.152.
 */
package dev.nelmin.logger;

import dev.nelmin.logger.DebugLoggingStrategy;
import dev.nelmin.logger.LoggingStrategy;
import dev.nelmin.logger.StackTraceLoggingStrategy;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007J'\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\r2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0004\u001a\u00020\u00132\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\u00132\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\u00132\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00132\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fJ\u001f\u0010 \u001a\u00020\u00132\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0017\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/nelmin/logger/Logger;", "", "<init>", "()V", "debug", "", "name", "", "executor", "Ljava/util/concurrent/ExecutorService;", "debugStrategy", "Ldev/nelmin/logger/DebugLoggingStrategy;", "errorStrategy", "Ldev/nelmin/logger/LoggingStrategy;", "fatalStrategy", "infoStrategy", "stackTraceStrategy", "warnStrategy", "setName", "", "log", "strategy", "content", "", "(Ldev/nelmin/logger/LoggingStrategy;[Ljava/lang/Object;)V", "([Ljava/lang/Object;)V", "error", "fatal", "info", "stacktrace", "stackTrace", "", "warn", "Lumina"})
public final class Logger {
    @NotNull
    public static final Logger INSTANCE = new Logger();
    private static boolean debug;
    @NotNull
    private static String name;
    @NotNull
    private static final ExecutorService executor;
    @NotNull
    private static DebugLoggingStrategy debugStrategy;
    @NotNull
    private static final LoggingStrategy errorStrategy;
    @NotNull
    private static final LoggingStrategy fatalStrategy;
    @NotNull
    private static final LoggingStrategy infoStrategy;
    @NotNull
    private static final LoggingStrategy stackTraceStrategy;
    @NotNull
    private static final LoggingStrategy warnStrategy;

    private Logger() {
    }

    public final void setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Logger.name = name;
    }

    public final void log(@NotNull LoggingStrategy strategy, Object ... content) {
        Intrinsics.checkNotNullParameter(strategy, "strategy");
        Intrinsics.checkNotNullParameter(content, "content");
        String format_normal = "[%timestamp] - %log_level - %name - %content";
        String format_debug = "[%timestamp] - %log_level - %name - %package:%line - %content";
        strategy.log(name, debug ? format_debug : format_normal, System.currentTimeMillis(), Arrays.copyOf(content, content.length));
    }

    public final void debug(Object ... content) {
        Intrinsics.checkNotNullParameter(content, "content");
        this.log(debugStrategy, Arrays.copyOf(content, content.length));
    }

    public final void error(Object ... content) {
        Intrinsics.checkNotNullParameter(content, "content");
        this.log(errorStrategy, Arrays.copyOf(content, content.length));
    }

    public final void fatal(Object ... content) {
        Intrinsics.checkNotNullParameter(content, "content");
        this.log(fatalStrategy, Arrays.copyOf(content, content.length));
    }

    public final void info(Object ... content) {
        Intrinsics.checkNotNullParameter(content, "content");
        this.log(infoStrategy, Arrays.copyOf(content, content.length));
    }

    public final void stacktrace(@NotNull Throwable stackTrace) {
        Intrinsics.checkNotNullParameter(stackTrace, "stackTrace");
        Object[] objectArray = new Object[]{stackTrace};
        this.log(stackTraceStrategy, objectArray);
    }

    public final void warn(Object ... content) {
        Intrinsics.checkNotNullParameter(content, "content");
        this.log(warnStrategy, Arrays.copyOf(content, content.length));
    }

    static {
        Files.createDirectories(Path.of(System.getProperty("user.dir") + "/logs", new String[0]), new FileAttribute[0]);
        String string = System.getProperty("debugMode");
        debug = string != null ? Boolean.parseBoolean(string) : false;
        name = "Lumina";
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue(executorService, "newSingleThreadExecutor(...)");
        executor = executorService;
        debugStrategy = new DebugLoggingStrategy(executor, debug);
        errorStrategy = new LoggingStrategy("error", "ERROR", executor, "\u001b[0;31m");
        fatalStrategy = new LoggingStrategy("error", "FATAL", executor, "\u001b[1;31m");
        infoStrategy = new LoggingStrategy("info", "INFO", executor, "\u001b[0;36m");
        stackTraceStrategy = new StackTraceLoggingStrategy(executor);
        warnStrategy = new LoggingStrategy("info", "WARN", executor, "\u001b[0;33m");
    }
}

