/*
 * Decompiled with CFR 0.152.
 */
package dev.nelmin.logger;

import dev.nelmin.logger.LoggingStrategy;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J9\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/nelmin/logger/DebugLoggingStrategy;", "Ldev/nelmin/logger/LoggingStrategy;", "executor", "Ljava/util/concurrent/ExecutorService;", "inDebugMode", "", "<init>", "(Ljava/util/concurrent/ExecutorService;Z)V", "log", "", "name", "", "format", "timestamp", "", "content", "", "", "(Ljava/lang/String;Ljava/lang/String;J[Ljava/lang/Object;)V", "Lumina"})
public final class DebugLoggingStrategy
extends LoggingStrategy {
    @NotNull
    private final ExecutorService executor;
    private boolean inDebugMode;

    public DebugLoggingStrategy(@NotNull ExecutorService executor, boolean inDebugMode) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        super("debug", "DEBUG", executor, "\u001b[0;32m");
        this.executor = executor;
        this.inDebugMode = inDebugMode;
    }

    @Override
    public void log(@NotNull String name, @NotNull String format, long timestamp, Object ... content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[4];
        this.executor.execute(() -> DebugLoggingStrategy.log$lambda$0(content, this, name, format, timestamp, caller));
    }

    private static final void log$lambda$0(Object[] $content, DebugLoggingStrategy this$0, String $name, String $format, long $timestamp, StackTraceElement $caller) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = $content.length;
        for (int i = 0; i < n; ++i) {
            Object object = $content[i];
            stringBuilder.append(object);
        }
        try {
            if (this$0.inDebugMode) {
                Intrinsics.checkNotNull((Object)$caller);
                String string = this$0.generateConsoleMessage($name, stringBuilder, $format, $timestamp, $caller, Arrays.copyOf($content, $content.length));
                System.out.println((Object)string);
            }
            Intrinsics.checkNotNull((Object)$caller);
            this$0.writeToFile(this$0.generateLogFileMessage($name, stringBuilder, $format, $timestamp, $caller, Arrays.copyOf($content, $content.length)));
        }
        catch (IOException e) {
            System.err.println("Log write error: " + e.getMessage());
        }
    }
}

