/*
 * Decompiled with CFR 0.152.
 */
package dev.nelmin.logger;

import dev.nelmin.logger.ANSI;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB3\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J9\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e\"\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\u001fJQ\u0010 \u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001e\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010&JS\u0010'\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u00052\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001e\"\u0004\u0018\u00010\u0001H\u0016\u00a2\u0006\u0002\u0010&JO\u0010(\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0016\u0010\u001d\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u001e\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010&J\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u0005R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldev/nelmin/logger/LoggingStrategy;", "", "path", "Ljava/nio/file/Path;", "logLevel", "", "executor", "Ljava/util/concurrent/ExecutorService;", "ansiColor", "logToConsole", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/util/concurrent/ExecutorService;Ljava/lang/String;Z)V", "fileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/concurrent/ExecutorService;Ljava/lang/String;Z)V", "TIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getTIME_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "PATH", "LOG_LEVEL", "ANSIColor", "formatTimestamp", "timestamp", "", "log", "", "name", "format", "content", "", "(Ljava/lang/String;Ljava/lang/String;J[Ljava/lang/Object;)V", "generateMessage", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "caller", "Ljava/lang/StackTraceElement;", "(Ljava/lang/String;Ljava/lang/StringBuilder;Ljava/lang/String;JLjava/lang/StackTraceElement;[Ljava/lang/Object;)Ljava/lang/String;", "generateConsoleMessage", "generateLogFileMessage", "writeToFile", "message", "Lumina"})
public class LoggingStrategy {
    @NotNull
    private final DateTimeFormatter TIME_FORMATTER;
    @NotNull
    private final Path PATH;
    @NotNull
    private final String LOG_LEVEL;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final String ANSIColor;
    private final boolean logToConsole;

    @NotNull
    public final DateTimeFormatter getTIME_FORMATTER() {
        return this.TIME_FORMATTER;
    }

    public LoggingStrategy(@NotNull Path path, @NotNull String logLevel, @NotNull ExecutorService executor, @NotNull String ansiColor, boolean logToConsole) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)ansiColor, (String)"ansiColor");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        this.TIME_FORMATTER = dateTimeFormatter;
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        this.PATH = path2;
        this.LOG_LEVEL = logLevel;
        this.executor = executor;
        this.ANSIColor = ansiColor;
        this.logToConsole = logToConsole;
    }

    public /* synthetic */ LoggingStrategy(Path path, String string, ExecutorService executorService, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(path, string, executorService, string2, bl);
    }

    public LoggingStrategy(@NotNull String fileName, @NotNull String logLevel, @NotNull ExecutorService executor, @NotNull String ansiColor, boolean logToConsole) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)ansiColor, (String)"ansiColor");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        this.TIME_FORMATTER = dateTimeFormatter;
        String string = System.getProperty("user.dir");
        String[] stringArray = new String[2];
        stringArray[0] = "logs";
        String string2 = fileName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        stringArray[1] = string2 + ".log";
        Path path = Path.of(string, stringArray).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        this.PATH = path;
        this.LOG_LEVEL = logLevel;
        this.executor = executor;
        this.ANSIColor = ansiColor;
        this.logToConsole = logToConsole;
    }

    public /* synthetic */ LoggingStrategy(String string, String string2, ExecutorService executorService, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(string, string2, executorService, string3, bl);
    }

    @NotNull
    public final String formatTimestamp(long timestamp) {
        String string = this.TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    public void log(@NotNull String name, @NotNull String format, long timestamp, Object ... content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller = stackTraceElements[4];
        this.executor.execute(() -> LoggingStrategy.log$lambda$0(content, this, name, format, timestamp, caller));
    }

    @NotNull
    public String generateMessage(@NotNull String name, @NotNull StringBuilder builder, @NotNull String format, long timestamp, @NotNull StackTraceElement caller, Object ... content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = StringsKt.replace$default((String)StringsKt.replace$default((String)format, (String)"%timestamp", (String)this.formatTimestamp(timestamp), (boolean)false, (int)4, null), (String)"%name", (String)name, (boolean)false, (int)4, null);
        String string2 = caller.getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getClassName(...)");
        String newFormat = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"%package", (String)string2, (boolean)false, (int)4, null), (String)"%line", (String)String.valueOf(caller.getLineNumber()), (boolean)false, (int)4, null);
        String string3 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)newFormat, (String)"%content", (String)string3, (boolean)false, (int)4, null), (String)"\n ", (String)StringsKt.trimIndent((String)("\n     \n     " + StringsKt.replace$default((String)newFormat, (String)"%content", (String)"", (boolean)false, (int)4, null) + "\n     ")), (boolean)false, (int)4, null);
    }

    @Nullable
    public String generateConsoleMessage(@NotNull String name, @NotNull StringBuilder builder, @NotNull String format, long timestamp, @NotNull StackTraceElement caller, Object ... content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return ANSI.translateToANSI$default(ANSI.INSTANCE, StringsKt.replace$default((String)this.generateMessage(name, builder, format, timestamp, caller, Arrays.copyOf(content, content.length)), (String)"%log_level", (String)(this.ANSIColor + this.LOG_LEVEL + "\u001b[0m"), (boolean)false, (int)4, null), '\u0000', 2, null);
    }

    @NotNull
    public final String generateLogFileMessage(@NotNull String name, @NotNull StringBuilder builder, @NotNull String format, long timestamp, @NotNull StackTraceElement caller, Object ... content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String fileFormat = format;
        if (!StringsKt.contains$default((CharSequence)fileFormat, (CharSequence)"%package:%line", (boolean)false, (int)2, null)) {
            CharSequence charSequence = fileFormat;
            Regex regex = new Regex("%log_level");
            String string = "%log_level - %package:%line";
            fileFormat = regex.replaceFirst(charSequence, string);
        }
        return StringsKt.replace$default((String)this.generateMessage(name, builder, fileFormat, timestamp, caller, Arrays.copyOf(content, content.length)), (String)"%log_level", (String)this.LOG_LEVEL, (boolean)false, (int)4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToFile(@NotNull String message) throws IOException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
        object = Files.newBufferedWriter(this.PATH, StandardCharsets.UTF_8, object);
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            writer.write(message);
            writer.newLine();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private static final void log$lambda$0(Object[] $content, LoggingStrategy this$0, String $name, String $format, long $timestamp, StackTraceElement $caller) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = $content.length;
        for (int i = 0; i < n; ++i) {
            Object object = $content[i];
            stringBuilder.append(object);
        }
        try {
            if (this$0.logToConsole) {
                Intrinsics.checkNotNull((Object)$caller);
                String string = this$0.generateConsoleMessage($name, stringBuilder, $format, $timestamp, $caller, Arrays.copyOf($content, $content.length));
                System.out.println((Object)string);
            }
            Intrinsics.checkNotNull((Object)$caller);
            this$0.writeToFile(this$0.generateLogFileMessage($name, stringBuilder, $format, $timestamp, $caller, Arrays.copyOf($content, $content.length)));
        }
        catch (IOException e) {
            System.err.println("Log write error: " + e.getMessage());
        }
    }
}

