/*
 * Decompiled with CFR 0.152.
 */
package dev.nelmin.logger;

import dev.nelmin.logger.LoggingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JQ\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014JS\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00192\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00192\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u001e"}, d2={"Ldev/nelmin/logger/StackTraceLoggingStrategy;", "Ldev/nelmin/logger/LoggingStrategy;", "executor", "Ljava/util/concurrent/ExecutorService;", "<init>", "(Ljava/util/concurrent/ExecutorService;)V", "generateMessage", "", "name", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "format", "timestamp", "", "caller", "Ljava/lang/StackTraceElement;", "content", "", "", "(Ljava/lang/String;Ljava/lang/StringBuilder;Ljava/lang/String;JLjava/lang/StackTraceElement;[Ljava/lang/Object;)Ljava/lang/String;", "generateConsoleMessage", "processThrowable", "", "throwable", "", "addExceptionDetails", "ex", "addCauseDetails", "cause", "Lumina"})
@SourceDebugExtension(value={"SMAP\nStackTraceLoggingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackTraceLoggingStrategy.kt\ndev/nelmin/logger/StackTraceLoggingStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,170:1\n739#2,9:171\n37#3:180\n36#3,3:181\n*S KotlinDebug\n*F\n+ 1 StackTraceLoggingStrategy.kt\ndev/nelmin/logger/StackTraceLoggingStrategy\n*L\n95#1:171,9\n95#1:180\n95#1:181,3\n*E\n"})
public final class StackTraceLoggingStrategy
extends LoggingStrategy {
    public StackTraceLoggingStrategy(@NotNull ExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        super("error", "STACKTRACE", executor, "\u001b[1;31m", false, 16, null);
    }

    @Override
    @NotNull
    public String generateMessage(@NotNull String name, @NotNull StringBuilder builder, @NotNull String format, long timestamp, @NotNull StackTraceElement caller, Object ... content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StringBuilder messageBuilder = new StringBuilder();
        String string = "[%s] ----------- STACKTRACE BEGIN -----------";
        Object object = new Object[]{this.formatTimestamp(timestamp)};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String header = string2;
        messageBuilder.append(header).append("\n");
        for (Object obj : content) {
            if (!(obj instanceof Throwable)) continue;
            this.processThrowable(name, (Throwable)obj, messageBuilder, timestamp);
        }
        object = "[%s] -----------  STACKTRACE END  -----------";
        Object[] objectArray = new Object[]{this.formatTimestamp(timestamp)};
        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String footer = string3;
        messageBuilder.append(footer);
        String string4 = messageBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String generateConsoleMessage(@NotNull String name, @NotNull StringBuilder builder, @NotNull String format, long timestamp, @NotNull StackTraceElement caller, Object ... content) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String message = this.generateMessage(name, builder, format, timestamp, caller, Arrays.copyOf(content, content.length));
        Object object = message;
        Regex regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        List<String> lines = Arrays.asList(Arrays.copyOf(stringArray, stringArray.length));
        String coloredBegin = "\u001b[1;31mSTACKTRACE BEGIN\u001b[0m";
        String coloredEnd = "\u001b[1;31mSTACKTRACE END\u001b[0m";
        Intrinsics.checkNotNull(lines);
        Object object2 = CollectionsKt.first(lines);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"first(...)");
        lines.set(0, StringsKt.replace$default((String)((String)object2), (String)"STACKTRACE BEGIN", (String)coloredBegin, (boolean)false, (int)4, null));
        int n2 = lines.size() - 1;
        Object object3 = CollectionsKt.last(lines);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"last(...)");
        lines.set(n2, StringsKt.replace$default((String)((String)object3), (String)"STACKTRACE END", (String)coloredEnd, (boolean)false, (int)4, null));
        return String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)lines);
    }

    private final void processThrowable(String name, Throwable throwable, StringBuilder builder, long timestamp) {
        String string = "[%s] From (Module/Plugin/CandleMC): %s";
        Object[] objectArray = new Object[]{this.formatTimestamp(timestamp), name};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        builder.append(string2).append("\n");
        this.addExceptionDetails(throwable, builder, timestamp);
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            this.addCauseDetails(cause, builder, timestamp);
        }
    }

    private final void addExceptionDetails(Throwable ex, StringBuilder builder, long timestamp) {
        String string = "[%s] Exception: %s\n[%s] Message: %s\n[%s] At: %s - %s:%d";
        Object[] objectArray = new Object[]{this.formatTimestamp(timestamp), ex.getClass().getName(), this.formatTimestamp(timestamp), ex.getMessage() != null ? ex.getMessage() : "N/A", this.formatTimestamp(timestamp), ex.getStackTrace()[0].getClassName(), ex.getStackTrace()[0].getFileName(), ex.getStackTrace()[0].getLineNumber()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String line = string2;
        builder.append(line).append("\n");
    }

    private final void addCauseDetails(Throwable cause, StringBuilder builder, long timestamp) {
        String string = "[%s] Caused by: %s\n[%s] Message: %s";
        Object[] objectArray = new Object[]{this.formatTimestamp(timestamp), cause.getClass().getName(), this.formatTimestamp(timestamp), cause.getMessage() != null ? cause.getMessage() : "N/A"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String line = string2;
        builder.append(line).append("\n");
    }
}

