/*
 * Decompiled with CFR 0.152.
 */
package dev.nelmin.logger;

import dev.nelmin.logger.LoggerUtils;
import dev.nelmin.logger.LoggingStrategy;
import dev.nelmin.logger.LoggingStrategyBuilder;
import dev.nelmin.logger.StackTraceLoggingStrategy;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import kotlinx.datetime.Clock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007J2\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00052\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u0001H\u0086@\u00a2\u0006\u0002\u0010\"J,\u0010\u0004\u001a\u00020\u001c2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010#J,\u0010$\u001a\u00020\u001c2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010#J,\u0010%\u001a\u00020\u001c2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010#J,\u0010&\u001a\u00020\u001c2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010#J \u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010*J,\u0010+\u001a\u00020\u001c2\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010!\"\u00020\u00012\b\b\u0002\u0010\u001f\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Ldev/nelmin/logger/Logger;", "", "<init>", "()V", "debug", "", "name", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "setCoroutineScope", "(Lkotlinx/coroutines/CoroutineScope;)V", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "getMutex", "()Lkotlinx/coroutines/sync/Mutex;", "setMutex", "(Lkotlinx/coroutines/sync/Mutex;)V", "debugStrategy", "Ldev/nelmin/logger/LoggingStrategy;", "errorStrategy", "fatalStrategy", "infoStrategy", "stackTraceStrategy", "warnStrategy", "setName", "", "log", "strategy", "logToConsole", "content", "", "(Ldev/nelmin/logger/LoggingStrategy;Z[Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "([Ljava/lang/Object;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "error", "fatal", "info", "stacktrace", "stackTrace", "", "(Ljava/lang/Throwable;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "warn", "Lumina"})
public final class Logger {
    @NotNull
    public static final Logger INSTANCE = new Logger();
    private static boolean debug;
    @NotNull
    private static String name;
    @NotNull
    private static CoroutineScope coroutineScope;
    @NotNull
    private static Mutex mutex;
    @NotNull
    private static final LoggingStrategy debugStrategy;
    @NotNull
    private static final LoggingStrategy errorStrategy;
    @NotNull
    private static final LoggingStrategy fatalStrategy;
    @NotNull
    private static final LoggingStrategy infoStrategy;
    @NotNull
    private static final LoggingStrategy stackTraceStrategy;
    @NotNull
    private static final LoggingStrategy warnStrategy;

    private Logger() {
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return coroutineScope;
    }

    public final void setCoroutineScope(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"<set-?>");
        Logger.coroutineScope = coroutineScope;
    }

    @NotNull
    public final Mutex getMutex() {
        return mutex;
    }

    public final void setMutex(@NotNull Mutex mutex) {
        Intrinsics.checkNotNullParameter((Object)mutex, (String)"<set-?>");
        Logger.mutex = mutex;
    }

    public final void setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Logger.name = name;
    }

    @Nullable
    public final Object log(@NotNull LoggingStrategy strategy, boolean logToConsole, @NotNull Object[] content, @NotNull Continuation<? super Unit> $completion) {
        Object object = strategy.log(name, debug ? "[%timestamp] - %strategyName - %loggerName - %package:%line - %content" : "[%timestamp] - %strategyName - %loggerName - %content", Clock.System.INSTANCE.now(), logToConsole, Arrays.copyOf(content, content.length), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object debug(@NotNull Object[] content, boolean logToConsole, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.log(debugStrategy, logToConsole, Arrays.copyOf(content, content.length), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object debug$default(Logger logger, Object[] objectArray, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return logger.debug(objectArray, bl, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object error(@NotNull Object[] content, boolean logToConsole, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.log(errorStrategy, logToConsole, Arrays.copyOf(content, content.length), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object error$default(Logger logger, Object[] objectArray, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return logger.error(objectArray, bl, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object fatal(@NotNull Object[] content, boolean logToConsole, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.log(fatalStrategy, logToConsole, Arrays.copyOf(content, content.length), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object fatal$default(Logger logger, Object[] objectArray, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return logger.fatal(objectArray, bl, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object info(@NotNull Object[] content, boolean logToConsole, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.log(infoStrategy, logToConsole, Arrays.copyOf(content, content.length), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object info$default(Logger logger, Object[] objectArray, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return logger.info(objectArray, bl, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object stacktrace(@NotNull Throwable stackTrace, boolean logToConsole, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new Object[]{stackTrace};
        Object object = this.log(stackTraceStrategy, logToConsole, objectArray, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object stacktrace$default(Logger logger, Throwable throwable, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return logger.stacktrace(throwable, bl, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object warn(@NotNull Object[] content, boolean logToConsole, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.log(warnStrategy, logToConsole, Arrays.copyOf(content, content.length), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object warn$default(Logger logger, Object[] objectArray, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return logger.warn(objectArray, bl, (Continuation<? super Unit>)continuation);
    }

    static {
        Files.createDirectories(LoggerUtils.INSTANCE.getLogsDir(), new FileAttribute[0]);
        String string = System.getProperty("debugMode");
        debug = string != null ? Boolean.parseBoolean(string) : false;
        name = "Lumina";
        coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        debugStrategy = new LoggingStrategyBuilder("DEBUG", coroutineScope, mutex, "\u001b[0;32m");
        errorStrategy = new LoggingStrategyBuilder("ERROR", coroutineScope, mutex, "\u001b[0;31m");
        fatalStrategy = new LoggingStrategyBuilder("FATAL", coroutineScope, mutex, "\u001b[1;31m");
        infoStrategy = new LoggingStrategyBuilder("INFO", coroutineScope, mutex, "\u001b[0;36m");
        stackTraceStrategy = new StackTraceLoggingStrategy(coroutineScope, mutex, "\u001b[1;31m");
        warnStrategy = new LoggingStrategyBuilder("WARN", coroutineScope, mutex, "\u001b[0;33m");
    }
}

