/*
 * Decompiled with CFR 0.152.
 */
package dev.nelmin.logger;

import dev.nelmin.logger.Logger;
import dev.nelmin.logger.strategy.LoggingStrategy;
import dev.nelmin.logger.strategy.LoggingStrategyBuilder;
import dev.nelmin.logger.strategy.StackTraceLoggingStrategy;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ldev/nelmin/logger/DefaultLoggingStrategies;", "", "<init>", "()V", "debugStrategy", "Ldev/nelmin/logger/strategy/LoggingStrategy;", "getDebugStrategy", "()Ldev/nelmin/logger/strategy/LoggingStrategy;", "errorStrategy", "getErrorStrategy", "fatalStrategy", "getFatalStrategy", "infoStrategy", "getInfoStrategy", "stackTraceStrategy", "getStackTraceStrategy", "warnStrategy", "getWarnStrategy", "Lumina"})
public final class DefaultLoggingStrategies {
    @NotNull
    public static final DefaultLoggingStrategies INSTANCE = new DefaultLoggingStrategies();
    @NotNull
    private static final LoggingStrategy debugStrategy = new LoggingStrategyBuilder("DEBUG", Logger.INSTANCE.getCoroutineScope(), Logger.INSTANCE.getMutex(), "\u001b[0;32m");
    @NotNull
    private static final LoggingStrategy errorStrategy = new LoggingStrategyBuilder("ERROR", Logger.INSTANCE.getCoroutineScope(), Logger.INSTANCE.getMutex(), "\u001b[0;31m");
    @NotNull
    private static final LoggingStrategy fatalStrategy = new LoggingStrategyBuilder("FATAL", Logger.INSTANCE.getCoroutineScope(), Logger.INSTANCE.getMutex(), "\u001b[1;31m");
    @NotNull
    private static final LoggingStrategy infoStrategy = new LoggingStrategyBuilder("INFO", Logger.INSTANCE.getCoroutineScope(), Logger.INSTANCE.getMutex(), "\u001b[0;36m");
    @NotNull
    private static final LoggingStrategy stackTraceStrategy = new StackTraceLoggingStrategy(Logger.INSTANCE.getCoroutineScope(), Logger.INSTANCE.getMutex(), "\u001b[1;31m");
    @NotNull
    private static final LoggingStrategy warnStrategy = new LoggingStrategyBuilder("WARN", Logger.INSTANCE.getCoroutineScope(), Logger.INSTANCE.getMutex(), "\u001b[0;33m");

    private DefaultLoggingStrategies() {
    }

    @NotNull
    public final LoggingStrategy getDebugStrategy() {
        return debugStrategy;
    }

    @NotNull
    public final LoggingStrategy getErrorStrategy() {
        return errorStrategy;
    }

    @NotNull
    public final LoggingStrategy getFatalStrategy() {
        return fatalStrategy;
    }

    @NotNull
    public final LoggingStrategy getInfoStrategy() {
        return infoStrategy;
    }

    @NotNull
    public final LoggingStrategy getStackTraceStrategy() {
        return stackTraceStrategy;
    }

    @NotNull
    public final LoggingStrategy getWarnStrategy() {
        return warnStrategy;
    }
}

