/*
 * Decompiled with CFR 0.152.
 */
package dev.nelmin.logger;

import java.nio.file.Path;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalDateTimeKt;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.DateTimeFormatBuilderKt;
import kotlinx.datetime.format.Padding;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Ldev/nelmin/logger/LoggerUtils;", "", "<init>", "()V", "TIME_FORMAT", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalDateTime;", "getTIME_FORMAT", "()Lkotlinx/datetime/format/DateTimeFormat;", "DATE_FORMAT", "getDATE_FORMAT", "getFormattedTime", "", "timestamp", "Lkotlinx/datetime/Instant;", "getFormattedDate", "logsDir", "Ljava/nio/file/Path;", "getLogsDir", "()Ljava/nio/file/Path;", "getLogFileForStrategy", "strategyName", "Lumina"})
public final class LoggerUtils {
    @NotNull
    public static final LoggerUtils INSTANCE = new LoggerUtils();
    @NotNull
    private static final DateTimeFormat<LocalDateTime> TIME_FORMAT = LocalDateTime.Companion.Format(LoggerUtils::TIME_FORMAT$lambda$0);
    @NotNull
    private static final DateTimeFormat<LocalDateTime> DATE_FORMAT = LocalDateTime.Companion.Format(LoggerUtils::DATE_FORMAT$lambda$1);
    @NotNull
    private static final Path logsDir;

    private LoggerUtils() {
    }

    @NotNull
    public final DateTimeFormat<LocalDateTime> getTIME_FORMAT() {
        return TIME_FORMAT;
    }

    @NotNull
    public final DateTimeFormat<LocalDateTime> getDATE_FORMAT() {
        return DATE_FORMAT;
    }

    @NotNull
    public final String getFormattedTime(@NotNull Instant timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        return LocalDateTimeKt.format((LocalDateTime)TimeZoneKt.toLocalDateTime((Instant)timestamp, (TimeZone)TimeZone.Companion.currentSystemDefault()), TIME_FORMAT);
    }

    public static /* synthetic */ String getFormattedTime$default(LoggerUtils loggerUtils, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            instant = Clock.System.INSTANCE.now();
        }
        return loggerUtils.getFormattedTime(instant);
    }

    @NotNull
    public final String getFormattedDate() {
        return LocalDateTimeKt.format((LocalDateTime)TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)TimeZone.Companion.currentSystemDefault()), DATE_FORMAT);
    }

    @NotNull
    public final Path getLogsDir() {
        return logsDir;
    }

    @NotNull
    public final Path getLogFileForStrategy(@NotNull String strategyName) {
        Intrinsics.checkNotNullParameter((Object)strategyName, (String)"strategyName");
        String string = strategyName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Path path = logsDir.resolve(string + ".log");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final Unit TIME_FORMAT$lambda$0(DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        $this$Format.hour(Padding.ZERO);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
        $this$Format.minute(Padding.ZERO);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
        $this$Format.second(Padding.ZERO);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)':');
        $this$Format.secondFraction(3);
        return Unit.INSTANCE;
    }

    private static final Unit DATE_FORMAT$lambda$1(DateTimeFormatBuilder.WithDateTime $this$Format) {
        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
        $this$Format.dayOfMonth(Padding.ZERO);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'.');
        $this$Format.monthNumber(Padding.ZERO);
        DateTimeFormatBuilderKt.char((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (char)'.');
        $this$Format.year(Padding.ZERO);
        return Unit.INSTANCE;
    }

    static {
        String[] stringArray = new String[]{"logs", INSTANCE.getFormattedDate()};
        Path path = Path.of(System.getProperty("user.dir"), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        logsDir = path;
    }
}

