/*
 * Decompiled with CFR 0.152.
 */
package dev.nelmin.logger.strategy;

import dev.nelmin.logger.LoggerUtils;
import dev.nelmin.logger.strategy.LoggingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJQ\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017JS\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u00072\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J,\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001c2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001c2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006!"}, d2={"Ldev/nelmin/logger/strategy/StackTraceLoggingStrategy;", "Ldev/nelmin/logger/strategy/LoggingStrategy;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "ansiColor", "", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/sync/Mutex;Ljava/lang/String;)V", "generateMessage", "name", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "format", "timestamp", "Lkotlinx/datetime/Instant;", "caller", "Ljava/lang/StackTraceElement;", "content", "", "", "(Ljava/lang/String;Ljava/lang/StringBuilder;Ljava/lang/String;Lkotlinx/datetime/Instant;Ljava/lang/StackTraceElement;[Ljava/lang/Object;)Ljava/lang/String;", "generateConsoleMessage", "processThrowable", "", "throwable", "", "addExceptionDetails", "ex", "addCauseDetails", "cause", "Lumina"})
@SourceDebugExtension(value={"SMAP\nStackTraceLoggingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackTraceLoggingStrategy.kt\ndev/nelmin/logger/strategy/StackTraceLoggingStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,163:1\n739#2,9:164\n37#3:173\n36#3,3:174\n*S KotlinDebug\n*F\n+ 1 StackTraceLoggingStrategy.kt\ndev/nelmin/logger/strategy/StackTraceLoggingStrategy\n*L\n85#1:164,9\n85#1:173\n85#1:174,3\n*E\n"})
public final class StackTraceLoggingStrategy
extends LoggingStrategy {
    public StackTraceLoggingStrategy(@NotNull CoroutineScope coroutineScope, @NotNull Mutex mutex, @NotNull String ansiColor) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)mutex, (String)"mutex");
        Intrinsics.checkNotNullParameter((Object)ansiColor, (String)"ansiColor");
        super("STACKTRACE", coroutineScope, mutex, ansiColor);
    }

    @Override
    @NotNull
    public String generateMessage(@NotNull String name, @NotNull StringBuilder builder, @NotNull String format, @NotNull Instant timestamp, @NotNull StackTraceElement caller, Object ... content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StringBuilder messageBuilder = new StringBuilder();
        String string = "[%s] ----------- STACKTRACE BEGIN -----------";
        Object object = new Object[]{LoggerUtils.INSTANCE.getFormattedTime(timestamp)};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String header = string2;
        messageBuilder.append(header).append("\n");
        for (Object obj : content) {
            if (!(obj instanceof Throwable)) continue;
            this.processThrowable(name, (Throwable)obj, messageBuilder, timestamp);
        }
        object = "[%s] -----------  STACKTRACE END  -----------";
        Object[] objectArray = new Object[]{LoggerUtils.INSTANCE.getFormattedTime(timestamp)};
        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String footer = string3;
        messageBuilder.append(footer);
        String string4 = messageBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String generateConsoleMessage(@NotNull String name, @NotNull StringBuilder builder, @NotNull String format, @NotNull Instant timestamp, @NotNull StackTraceElement caller, Object ... content) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String message = this.generateMessage(name, builder, format, timestamp, caller, Arrays.copyOf(content, content.length));
        Object object = message;
        Regex regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        List lines = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
        String coloredBegin = "\u001b[1;31mSTACKTRACE BEGIN\u001b[0m";
        String coloredEnd = "\u001b[1;31mSTACKTRACE END\u001b[0m";
        lines.set(0, StringsKt.replace$default((String)((String)CollectionsKt.first((List)lines)), (String)"STACKTRACE BEGIN", (String)coloredBegin, (boolean)false, (int)4, null));
        lines.set(lines.size() - 1, StringsKt.replace$default((String)((String)CollectionsKt.last((List)lines)), (String)"STACKTRACE END", (String)coloredEnd, (boolean)false, (int)4, null));
        return String.join((CharSequence)"\n", lines);
    }

    private final void processThrowable(String name, Throwable throwable, StringBuilder builder, Instant timestamp) {
        String string = "[%s] From (Logger Name): %s";
        Object[] objectArray = new Object[]{LoggerUtils.INSTANCE.getFormattedTime(timestamp), name};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        builder.append(string2).append("\n");
        this.addExceptionDetails(throwable, builder, timestamp);
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            this.addCauseDetails(cause, builder, timestamp);
        }
    }

    private final void addExceptionDetails(Throwable ex, StringBuilder builder, Instant timestamp) {
        String string = "[%s] Exception: %s\n[%s] Message: %s\n[%s] At: %s - %s:%d";
        Object[] objectArray = new Object[]{LoggerUtils.INSTANCE.getFormattedTime(timestamp), ex.getClass().getName(), LoggerUtils.INSTANCE.getFormattedTime(timestamp), ex.getMessage() != null ? ex.getMessage() : "N/A", LoggerUtils.INSTANCE.getFormattedTime(timestamp), ex.getStackTrace()[0].getClassName(), ex.getStackTrace()[0].getFileName(), ex.getStackTrace()[0].getLineNumber()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String line = string2;
        builder.append(line).append("\n");
    }

    private final void addCauseDetails(Throwable cause, StringBuilder builder, Instant timestamp) {
        String string = "[%s] Caused by: %s\n[%s] Message: %s";
        Object[] objectArray = new Object[]{LoggerUtils.INSTANCE.getFormattedTime(timestamp), cause.getClass().getName(), LoggerUtils.INSTANCE.getFormattedTime(timestamp), cause.getMessage() != null ? cause.getMessage() : "N/A"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String line = string2;
        builder.append(line).append("\n");
    }
}

