/*
 * Decompiled with CFR 0.152.
 */
package dev.nelmin.logger;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b>\n\u0002\u0010\f\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010B\u001a\u0004\u0018\u00010\u00052\u0006\u0010C\u001a\u00020DH\u0002J\u000e\u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Ldev/nelmin/logger/ANSI;", "", "<init>", "()V", "BLACK", "", "RED", "GREEN", "YELLOW", "BLUE", "PURPLE", "CYAN", "WHITE", "BOLD_BLACK", "BOLD_RED", "BOLD_GREEN", "BOLD_YELLOW", "BOLD_BLUE", "BOLD_PURPLE", "BOLD_CYAN", "BOLD_WHITE", "UNDERLINE_BLACK", "UNDERLINE_RED", "UNDERLINE_GREEN", "UNDERLINE_YELLOW", "UNDERLINE_BLUE", "UNDERLINE_PURPLE", "UNDERLINE_CYAN", "UNDERLINE_WHITE", "BACKGROUND_BLACK", "BACKGROUND_RED", "BACKGROUND_GREEN", "BACKGROUND_YELLOW", "BACKGROUND_BLUE", "BACKGROUND_PURPLE", "BACKGROUND_CYAN", "BACKGROUND_WHITE", "HIGH_INTENSITY_BLACK", "HIGH_INTENSITY_RED", "HIGH_INTENSITY_GREEN", "HIGH_INTENSITY_YELLOW", "HIGH_INTENSITY_BLUE", "HIGH_INTENSITY_PURPLE", "HIGH_INTENSITY_CYAN", "HIGH_INTENSITY_WHITE", "BOLD_HIGH_INTENSITY_BLACK", "BOLD_HIGH_INTENSITY_RED", "BOLD_HIGH_INTENSITY_GREEN", "BOLD_HIGH_INTENSITY_YELLOW", "BOLD_HIGH_INTENSITY_BLUE", "BOLD_HIGH_INTENSITY_PURPLE", "BOLD_HIGH_INTENSITY_CYAN", "BOLD_HIGH_INTENSITY_WHITE", "BACKGROUND_HIGH_INTENSITY_BLACK", "BACKGROUND_HIGH_INTENSITY_RED", "BACKGROUND_HIGH_INTENSITY_GREEN", "BACKGROUND_HIGH_INTENSITY_YELLOW", "BACKGROUND_HIGH_INTENSITY_BLUE", "BACKGROUND_HIGH_INTENSITY_PURPLE", "BACKGROUND_HIGH_INTENSITY_CYAN", "BACKGROUND_HIGH_INTENSITY_WHITE", "RESET", "BOLD", "ITALIC", "UNDERLINE", "STRIKETHROUGH", "getANSICode", "colorChar", "", "translateToANSI", "text", "Lumina"})
public final class ANSI {
    @NotNull
    public static final ANSI INSTANCE = new ANSI();
    @NotNull
    public static final String BLACK = "\u001b[0;30m";
    @NotNull
    public static final String RED = "\u001b[0;31m";
    @NotNull
    public static final String GREEN = "\u001b[0;32m";
    @NotNull
    public static final String YELLOW = "\u001b[0;33m";
    @NotNull
    public static final String BLUE = "\u001b[0;34m";
    @NotNull
    public static final String PURPLE = "\u001b[0;35m";
    @NotNull
    public static final String CYAN = "\u001b[0;36m";
    @NotNull
    public static final String WHITE = "\u001b[0;37m";
    @NotNull
    public static final String BOLD_BLACK = "\u001b[1;30m";
    @NotNull
    public static final String BOLD_RED = "\u001b[1;31m";
    @NotNull
    public static final String BOLD_GREEN = "\u001b[1;32m";
    @NotNull
    public static final String BOLD_YELLOW = "\u001b[1;33m";
    @NotNull
    public static final String BOLD_BLUE = "\u001b[1;34m";
    @NotNull
    public static final String BOLD_PURPLE = "\u001b[1;35m";
    @NotNull
    public static final String BOLD_CYAN = "\u001b[1;36m";
    @NotNull
    public static final String BOLD_WHITE = "\u001b[1;37m";
    @NotNull
    public static final String UNDERLINE_BLACK = "\u001b[4;30m";
    @NotNull
    public static final String UNDERLINE_RED = "\u001b[4;31m";
    @NotNull
    public static final String UNDERLINE_GREEN = "\u001b[4;32m";
    @NotNull
    public static final String UNDERLINE_YELLOW = "\u001b[4;33m";
    @NotNull
    public static final String UNDERLINE_BLUE = "\u001b[4;34m";
    @NotNull
    public static final String UNDERLINE_PURPLE = "\u001b[4;35m";
    @NotNull
    public static final String UNDERLINE_CYAN = "\u001b[4;36m";
    @NotNull
    public static final String UNDERLINE_WHITE = "\u001b[4;37m";
    @NotNull
    public static final String BACKGROUND_BLACK = "\u001b[40m";
    @NotNull
    public static final String BACKGROUND_RED = "\u001b[41m";
    @NotNull
    public static final String BACKGROUND_GREEN = "\u001b[42m";
    @NotNull
    public static final String BACKGROUND_YELLOW = "\u001b[43m";
    @NotNull
    public static final String BACKGROUND_BLUE = "\u001b[44m";
    @NotNull
    public static final String BACKGROUND_PURPLE = "\u001b[45m";
    @NotNull
    public static final String BACKGROUND_CYAN = "\u001b[46m";
    @NotNull
    public static final String BACKGROUND_WHITE = "\u001b[47m";
    @NotNull
    public static final String HIGH_INTENSITY_BLACK = "\u001b[0;90m";
    @NotNull
    public static final String HIGH_INTENSITY_RED = "\u001b[0;91m";
    @NotNull
    public static final String HIGH_INTENSITY_GREEN = "\u001b[0;92m";
    @NotNull
    public static final String HIGH_INTENSITY_YELLOW = "\u001b[0;93m";
    @NotNull
    public static final String HIGH_INTENSITY_BLUE = "\u001b[0;94m";
    @NotNull
    public static final String HIGH_INTENSITY_PURPLE = "\u001b[0;95m";
    @NotNull
    public static final String HIGH_INTENSITY_CYAN = "\u001b[0;96m";
    @NotNull
    public static final String HIGH_INTENSITY_WHITE = "\u001b[0;97m";
    @NotNull
    public static final String BOLD_HIGH_INTENSITY_BLACK = "\u001b[1;90m";
    @NotNull
    public static final String BOLD_HIGH_INTENSITY_RED = "\u001b[1;91m";
    @NotNull
    public static final String BOLD_HIGH_INTENSITY_GREEN = "\u001b[1;92m";
    @NotNull
    public static final String BOLD_HIGH_INTENSITY_YELLOW = "\u001b[1;93m";
    @NotNull
    public static final String BOLD_HIGH_INTENSITY_BLUE = "\u001b[1;94m";
    @NotNull
    public static final String BOLD_HIGH_INTENSITY_PURPLE = "\u001b[1;95m";
    @NotNull
    public static final String BOLD_HIGH_INTENSITY_CYAN = "\u001b[1;96m";
    @NotNull
    public static final String BOLD_HIGH_INTENSITY_WHITE = "\u001b[1;97m";
    @NotNull
    public static final String BACKGROUND_HIGH_INTENSITY_BLACK = "\u001b[0;100m";
    @NotNull
    public static final String BACKGROUND_HIGH_INTENSITY_RED = "\u001b[0;101m";
    @NotNull
    public static final String BACKGROUND_HIGH_INTENSITY_GREEN = "\u001b[0;102m";
    @NotNull
    public static final String BACKGROUND_HIGH_INTENSITY_YELLOW = "\u001b[0;103m";
    @NotNull
    public static final String BACKGROUND_HIGH_INTENSITY_BLUE = "\u001b[0;104m";
    @NotNull
    public static final String BACKGROUND_HIGH_INTENSITY_PURPLE = "\u001b[0;105m";
    @NotNull
    public static final String BACKGROUND_HIGH_INTENSITY_CYAN = "\u001b[0;106m";
    @NotNull
    public static final String BACKGROUND_HIGH_INTENSITY_WHITE = "\u001b[0;107m";
    @NotNull
    public static final String RESET = "\u001b[0m";
    @NotNull
    public static final String BOLD = "\u001b[1m";
    @NotNull
    public static final String ITALIC = "\u001b[3m";
    @NotNull
    public static final String UNDERLINE = "\u001b[4m";
    @NotNull
    public static final String STRIKETHROUGH = "\u001b[9m";

    private ANSI() {
    }

    private final String getANSICode(char colorChar) {
        return switch (colorChar) {
            case '0' -> BLACK;
            case '1' -> BLUE;
            case '2' -> GREEN;
            case '3' -> CYAN;
            case '4' -> RED;
            case '5' -> PURPLE;
            case '6' -> YELLOW;
            case '7' -> WHITE;
            case '8' -> HIGH_INTENSITY_BLACK;
            case '9' -> HIGH_INTENSITY_BLUE;
            case 'a' -> HIGH_INTENSITY_GREEN;
            case 'b' -> HIGH_INTENSITY_CYAN;
            case 'c' -> HIGH_INTENSITY_RED;
            case 'd' -> HIGH_INTENSITY_PURPLE;
            case 'e' -> HIGH_INTENSITY_YELLOW;
            case 'f' -> HIGH_INTENSITY_WHITE;
            case 'g' -> YELLOW;
            case 'r' -> RESET;
            default -> null;
        };
    }

    @NotNull
    public final String translateToANSI(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        char c = '&';
        if (!StringsKt.contains$default((CharSequence)text, (char)c, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (char)'\\', (boolean)false, (int)2, null)) {
            return text;
        }
        StringBuilder result = new StringBuilder(text.length() + 32);
        int i = 0;
        int lastPos = 0;
        int length = text.length();
        while (i < length) {
            if (text.charAt(i) == '\\' && i + 1 < length && text.charAt(i + 1) == c) {
                if (lastPos < i) {
                    result.append(text, lastPos, i);
                }
                result.append(c);
                lastPos = i += 2;
                continue;
            }
            if (text.charAt(i) == c && i + 1 < length) {
                char nextChar = text.charAt(i + 1);
                char colorChar = ('A' <= nextChar ? nextChar < '[' : false) ? (char)(nextChar + 32) : nextChar;
                String ansiCode = this.getANSICode(colorChar);
                if (ansiCode != null) {
                    if (lastPos < i) {
                        result.append(text, lastPos, i);
                    }
                    result.append(ansiCode);
                    lastPos = i += 2;
                    continue;
                }
            }
            ++i;
        }
        if (lastPos < length) {
            result.append(text, lastPos, length);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

