/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.address.component;

import com.alibaba.nacos.common.utils.IPUtil;
import com.alibaba.nacos.naming.core.Instance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AddressServerGeneratorManager {
    public String generateProductName(String name) {
        if (StringUtils.isBlank((CharSequence)name) || "nacos".equals(name)) {
            return "nacos.as.default";
        }
        return String.format("nacos.as.%s", name);
    }

    public List<Instance> generateInstancesByIps(String serviceName, String rawProductName, String clusterName, String[] ipArray) {
        if (StringUtils.isEmpty((CharSequence)serviceName) || StringUtils.isEmpty((CharSequence)clusterName) || ipArray == null || ipArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Instance> instanceList = new ArrayList<Instance>(ipArray.length);
        for (String ip : ipArray) {
            String[] ipAndPort = this.generateIpAndPort(ip);
            Instance instance = new Instance();
            instance.setIp(ipAndPort[0]);
            instance.setPort(Integer.parseInt(ipAndPort[1]));
            instance.setClusterName(clusterName);
            instance.setServiceName(serviceName);
            instance.setTenant("public");
            instance.setApp(rawProductName);
            instance.setEphemeral(false);
            instanceList.add(instance);
        }
        return instanceList;
    }

    private String[] generateIpAndPort(String ip) {
        String[] result = IPUtil.splitIPPortStr((String)ip);
        if (result.length != 2) {
            return new String[]{result[0], String.valueOf(8848)};
        }
        return result;
    }

    public String generateResponseIps(List<Instance> instanceList) {
        StringBuilder ips = new StringBuilder();
        instanceList.forEach(instance -> {
            ips.append(instance.getIp() + ":" + instance.getPort());
            ips.append("\n");
        });
        return ips.toString();
    }

    public String generateNacosServiceName(String rawServiceName) {
        if (rawServiceName.indexOf("DEFAULT_GROUP") != -1) {
            return rawServiceName;
        }
        return "DEFAULT_GROUP@@" + rawServiceName;
    }
}

