/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.filter;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.io.IoFilter;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.filter.SSLByteBufferPool;
import org.apache.mina.io.filter.SSLFilter;
import org.apache.mina.util.Queue;

class SSLHandler {
    private static final Logger log = Logger.getLogger(SSLFilter.class.getName());
    private final SSLFilter parent;
    private final IoSession session;
    private final Queue nextFilterQueue = new Queue();
    private final Queue writeBufferQueue = new Queue();
    private final Queue writeMarkerQueue = new Queue();
    private SSLEngine sslEngine;
    private java.nio.ByteBuffer inNetBuffer;
    private java.nio.ByteBuffer outNetBuffer;
    private java.nio.ByteBuffer appBuffer;
    private java.nio.ByteBuffer hsBB = java.nio.ByteBuffer.allocate(0);
    private SSLEngineResult.HandshakeStatus initialHandshakeStatus;
    private boolean initialHandshakeComplete;
    private boolean shutdown = false;
    private boolean closed = false;
    private boolean isWritingEncryptedData = false;

    SSLHandler(SSLFilter parent, SSLContext sslc, IoSession session) throws SSLException {
        this.parent = parent;
        this.session = session;
        this.sslEngine = sslc.createSSLEngine();
        this.sslEngine.setUseClientMode(parent.isUseClientMode());
        this.sslEngine.setNeedClientAuth(parent.isNeedClientAuth());
        this.sslEngine.setWantClientAuth(parent.isWantClientAuth());
        if (parent.getEnabledCipherSuites() != null) {
            this.sslEngine.setEnabledCipherSuites(parent.getEnabledCipherSuites());
        }
        if (parent.getEnabledProtocols() != null) {
            this.sslEngine.setEnabledProtocols(parent.getEnabledProtocols());
        }
        this.sslEngine.beginHandshake();
        this.initialHandshakeStatus = this.sslEngine.getHandshakeStatus();
        this.initialHandshakeComplete = false;
        SSLByteBufferPool.initiate(this.sslEngine);
        this.appBuffer = SSLByteBufferPool.getApplicationBuffer();
        this.inNetBuffer = SSLByteBufferPool.getPacketBuffer();
        this.outNetBuffer = SSLByteBufferPool.getPacketBuffer();
        this.outNetBuffer.position(0);
        this.outNetBuffer.limit(0);
    }

    public void setWritingEncryptedData(boolean flag) {
        this.isWritingEncryptedData = flag;
    }

    public boolean isWritingEncryptedData() {
        return this.isWritingEncryptedData;
    }

    public boolean isInitialHandshakeComplete() {
        return this.initialHandshakeComplete;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean needToCompleteInitialHandshake() {
        return this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && !this.closed;
    }

    public synchronized void scheduleWrite(IoFilter.NextFilter nextFilter, ByteBuffer buf, Object marker) {
        this.nextFilterQueue.push(nextFilter);
        this.writeBufferQueue.push(buf);
        this.writeMarkerQueue.push(marker);
    }

    public synchronized void flushScheduledWrites() throws SSLException {
        ByteBuffer scheduledBuf;
        while ((scheduledBuf = (ByteBuffer)this.writeBufferQueue.pop()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this.session + " Flushing buffered write request: " + scheduledBuf);
            }
            IoFilter.NextFilter nextFilter = (IoFilter.NextFilter)this.nextFilterQueue.pop();
            Object scheduledMarker = this.writeMarkerQueue.pop();
            this.parent.filterWrite(nextFilter, this.session, scheduledBuf, scheduledMarker);
        }
    }

    public void dataRead(IoFilter.NextFilter nextFilter, java.nio.ByteBuffer buf) throws SSLException {
        if (buf.limit() > this.inNetBuffer.remaining()) {
            this.inNetBuffer = SSLByteBufferPool.expandBuffer(this.inNetBuffer, this.inNetBuffer.capacity() + buf.limit() * 2);
            this.appBuffer = SSLByteBufferPool.expandBuffer(this.appBuffer, this.inNetBuffer.capacity() * 2);
            this.appBuffer.position(0);
            this.appBuffer.limit(0);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this.session + " expanded inNetBuffer:" + this.inNetBuffer);
                log.log(Level.FINEST, this.session + " expanded appBuffer:" + this.appBuffer);
            }
        }
        this.inNetBuffer.put(buf);
        if (!this.initialHandshakeComplete) {
            this.doHandshake(nextFilter);
        } else {
            this.doDecrypt();
        }
    }

    public void continueHandshake(IoFilter.NextFilter nextFilter) throws SSLException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, this.session + " continueHandshake()");
        }
        this.doHandshake(nextFilter);
    }

    public java.nio.ByteBuffer getAppBuffer() {
        return this.appBuffer;
    }

    public java.nio.ByteBuffer getOutNetBuffer() {
        return this.outNetBuffer;
    }

    public void encrypt(java.nio.ByteBuffer buf) throws SSLException {
        this.doEncrypt(buf);
    }

    public void shutdown() throws SSLException {
        if (!this.shutdown) {
            this.doShutdown();
        }
    }

    public void release() {
        SSLByteBufferPool.release(this.appBuffer);
        SSLByteBufferPool.release(this.inNetBuffer);
        SSLByteBufferPool.release(this.outNetBuffer);
    }

    private void doDecrypt() throws SSLException {
        if (!this.initialHandshakeComplete) {
            throw new IllegalStateException();
        }
        if (this.appBuffer.hasRemaining()) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this.session + " Error: appBuffer not empty!");
            }
            throw new IllegalStateException();
        }
        this.unwrap();
    }

    private SSLEngineResult.Status checkStatus(SSLEngineResult.Status status) throws SSLException {
        if (status != SSLEngineResult.Status.OK && status != SSLEngineResult.Status.CLOSED && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            throw new SSLException("SSLEngine error during decrypt: " + (Object)((Object)status) + " inNetBuffer: " + this.inNetBuffer + "appBuffer: " + this.appBuffer);
        }
        return status;
    }

    private void doEncrypt(java.nio.ByteBuffer src) throws SSLException {
        if (!this.initialHandshakeComplete) {
            throw new IllegalStateException();
        }
        this.outNetBuffer.clear();
        while (src.hasRemaining()) {
            if (src.remaining() > (this.outNetBuffer.capacity() - this.outNetBuffer.position()) / 2) {
                this.outNetBuffer = SSLByteBufferPool.expandBuffer(this.outNetBuffer, src.capacity() * 2);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, this.session + " expanded outNetBuffer:" + this.outNetBuffer);
                }
            }
            SSLEngineResult result = this.sslEngine.wrap(src, this.outNetBuffer);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this.session + " Wrap res:" + result);
            }
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.doTasks();
                continue;
            }
            throw new SSLException("SSLEngine error during encrypt: " + (Object)((Object)result.getStatus()) + " src: " + src + "outNetBuffer: " + this.outNetBuffer);
        }
        this.outNetBuffer.flip();
    }

    synchronized void doHandshake(IoFilter.NextFilter nextFilter) throws SSLException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, this.session + " doHandshake()");
        }
        while (!this.initialHandshakeComplete) {
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                if (log.isLoggable(Level.FINEST)) {
                    SSLSession sslSession = this.sslEngine.getSession();
                    log.log(Level.FINEST, this.session + "  initialHandshakeStatus=FINISHED");
                    log.log(Level.FINEST, this.session + "  sslSession CipherSuite used " + sslSession.getCipherSuite());
                }
                this.initialHandshakeComplete = true;
                return;
            }
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, this.session + "  initialHandshakeStatus=NEED_TASK");
                }
                this.initialHandshakeStatus = this.doTasks();
                continue;
            }
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, this.session + "  initialHandshakeStatus=NEED_UNWRAP");
                }
                SSLEngineResult.Status status = this.unwrapHandshake();
                if ((this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || status != SSLEngineResult.Status.BUFFER_UNDERFLOW) && !this.closed) continue;
                return;
            }
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, this.session + "  initialHandshakeStatus=NEED_WRAP");
                }
                if (this.outNetBuffer.hasRemaining()) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, this.session + "  Still data in out buffer!");
                    }
                    return;
                }
                this.outNetBuffer.clear();
                SSLEngineResult result = this.sslEngine.wrap(this.hsBB, this.outNetBuffer);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, this.session + " Wrap res:" + result);
                }
                this.outNetBuffer.flip();
                this.initialHandshakeStatus = result.getHandshakeStatus();
                this.parent.writeNetBuffer(nextFilter, this.session, this);
                continue;
            }
            throw new IllegalStateException("Invalid Handshaking State" + (Object)((Object)this.initialHandshakeStatus));
        }
    }

    SSLEngineResult.Status unwrap() throws SSLException {
        SSLEngineResult res;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, this.session + " unwrap()");
        }
        this.appBuffer.clear();
        this.inNetBuffer.flip();
        do {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this.session + "   inNetBuffer: " + this.inNetBuffer);
                log.log(Level.FINEST, this.session + "   appBuffer: " + this.appBuffer);
            }
            res = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, this.session + " Unwrap res:" + res);
        } while (res.getStatus() == SSLEngineResult.Status.OK);
        if (res.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.closed = true;
        }
        this.inNetBuffer.compact();
        this.appBuffer.flip();
        return this.checkStatus(res.getStatus());
    }

    private SSLEngineResult.Status unwrapHandshake() throws SSLException {
        SSLEngineResult res;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, this.session + " unwrapHandshake()");
        }
        this.appBuffer.clear();
        this.inNetBuffer.flip();
        do {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this.session + "   inNetBuffer: " + this.inNetBuffer);
                log.log(Level.FINEST, this.session + "   appBuffer: " + this.appBuffer);
            }
            res = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
            if (!log.isLoggable(Level.FINEST)) continue;
            log.log(Level.FINEST, this.session + " Unwrap res:" + res);
        } while (res.getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        this.initialHandshakeStatus = res.getHandshakeStatus();
        if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED && this.appBuffer.position() == 0 && res.getStatus() == SSLEngineResult.Status.OK && this.inNetBuffer.hasRemaining()) {
            do {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, this.session + "  extra handshake unwrap");
                    log.log(Level.FINEST, this.session + "   inNetBuffer: " + this.inNetBuffer);
                    log.log(Level.FINEST, this.session + "   appBuffer: " + this.appBuffer);
                }
                res = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, this.session + " Unwrap res:" + res);
            } while (res.getStatus() == SSLEngineResult.Status.OK);
        }
        if (res.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.closed = true;
        }
        this.inNetBuffer.compact();
        this.appBuffer.flip();
        return this.checkStatus(res.getStatus());
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, this.session + "   doTasks()");
        }
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, this.session + "    doTask: " + runnable);
            }
            runnable.run();
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, this.session + "   doTasks(): " + (Object)((Object)this.sslEngine.getHandshakeStatus()));
        }
        return this.sslEngine.getHandshakeStatus();
    }

    void doShutdown() throws SSLException {
        if (!this.shutdown) {
            this.sslEngine.closeOutbound();
            this.shutdown = true;
        }
        this.outNetBuffer.clear();
        SSLEngineResult result = this.sslEngine.wrap(this.hsBB, this.outNetBuffer);
        if (result.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new SSLException("Improper close state: " + result);
        }
        this.outNetBuffer.flip();
    }
}

