/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.vmpipe;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.SessionConfig;
import org.apache.mina.protocol.vmpipe.VmPipeSession;

class VmPipeIdleStatusChecker {
    static final VmPipeIdleStatusChecker INSTANCE = new VmPipeIdleStatusChecker();
    private final Map sessions = new IdentityHashMap();
    private final Worker worker = new Worker();

    private VmPipeIdleStatusChecker() {
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSession(VmPipeSession session) {
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.put(session, session);
        }
    }

    private class Worker
    extends Thread {
        private Worker() {
            super("VmPipeIdleStatusChecker");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long currentTime = System.currentTimeMillis();
                Map map = VmPipeIdleStatusChecker.this.sessions;
                synchronized (map) {
                    Iterator it = VmPipeIdleStatusChecker.this.sessions.keySet().iterator();
                    while (it.hasNext()) {
                        long idleTime;
                        VmPipeSession session = (VmPipeSession)it.next();
                        if (!session.isConnected()) {
                            it.remove();
                            continue;
                        }
                        SessionConfig config = session.getConfig();
                        if (!session.isIdle(IdleStatus.BOTH_IDLE)) {
                            idleTime = config.getIdleTimeInMillis(IdleStatus.BOTH_IDLE);
                            session.setIdle(IdleStatus.BOTH_IDLE, idleTime > 0L && currentTime - session.getLastIoTime() > idleTime);
                            if (session.isIdle(IdleStatus.BOTH_IDLE)) {
                                session.getManagerFilterChain().sessionIdle(session, IdleStatus.BOTH_IDLE);
                            }
                        }
                        if (!session.isIdle(IdleStatus.READER_IDLE)) {
                            idleTime = config.getIdleTimeInMillis(IdleStatus.READER_IDLE);
                            session.setIdle(IdleStatus.READER_IDLE, idleTime > 0L && currentTime - session.getLastReadTime() > idleTime);
                            if (session.isIdle(IdleStatus.READER_IDLE)) {
                                session.getManagerFilterChain().sessionIdle(session, IdleStatus.READER_IDLE);
                            }
                        }
                        if (session.isIdle(IdleStatus.WRITER_IDLE)) continue;
                        idleTime = config.getIdleTimeInMillis(IdleStatus.WRITER_IDLE);
                        session.setIdle(IdleStatus.WRITER_IDLE, idleTime > 0L && currentTime - session.getLastWriteTime() > idleTime);
                        if (!session.isIdle(IdleStatus.WRITER_IDLE)) continue;
                        session.getManagerFilterChain().sessionIdle(session, IdleStatus.WRITER_IDLE);
                    }
                }
            }
        }
    }
}

