/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.registry;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.TransportType;
import org.apache.mina.io.IoAcceptor;
import org.apache.mina.io.IoHandler;
import org.apache.mina.io.datagram.DatagramAcceptor;
import org.apache.mina.io.filter.IoThreadPoolFilter;
import org.apache.mina.io.socket.SocketAcceptor;
import org.apache.mina.protocol.ProtocolAcceptor;
import org.apache.mina.protocol.ProtocolProvider;
import org.apache.mina.protocol.filter.ProtocolThreadPoolFilter;
import org.apache.mina.protocol.io.IoProtocolAcceptor;
import org.apache.mina.protocol.vmpipe.VmPipeAcceptor;
import org.apache.mina.protocol.vmpipe.VmPipeAddress;
import org.apache.mina.registry.Service;
import org.apache.mina.registry.ServiceRegistry;

public class SimpleServiceRegistry
implements ServiceRegistry {
    protected final IoAcceptor socketIoAcceptor = new SocketAcceptor();
    protected final IoAcceptor datagramIoAcceptor = new DatagramAcceptor();
    protected final ProtocolAcceptor socketProtocolAcceptor = new IoProtocolAcceptor(this.socketIoAcceptor);
    protected final ProtocolAcceptor datagramProtocolAcceptor = new IoProtocolAcceptor(this.datagramIoAcceptor);
    protected final ProtocolAcceptor vmPipeAcceptor = new VmPipeAcceptor();
    protected final IoThreadPoolFilter ioThreadPoolFilter = new IoThreadPoolFilter();
    protected final ProtocolThreadPoolFilter protocolThreadPoolFilter = new ProtocolThreadPoolFilter();
    private final Set services = new HashSet();

    public SimpleServiceRegistry() throws IOException {
        this.socketIoAcceptor.getFilterChain().addFirst("threadPool", this.ioThreadPoolFilter);
        this.datagramIoAcceptor.getFilterChain().addFirst("threadPool", this.ioThreadPoolFilter);
        this.socketProtocolAcceptor.getFilterChain().addFirst("threadPool", this.protocolThreadPoolFilter);
        this.datagramProtocolAcceptor.getFilterChain().addFirst("threadPool", this.protocolThreadPoolFilter);
        this.vmPipeAcceptor.getFilterChain().addFirst("threadPool", this.protocolThreadPoolFilter);
    }

    public void bind(Service service, IoHandler ioHandler) throws IOException {
        IoAcceptor acceptor = this.findIoAcceptor(service.getTransportType());
        acceptor.bind(service.getAddress(), ioHandler);
        this.startThreadPools();
        this.services.add(service);
    }

    public synchronized void bind(Service service, ProtocolProvider protocolProvider) throws IOException {
        ProtocolAcceptor acceptor = this.findProtocolAcceptor(service.getTransportType());
        acceptor.bind(service.getAddress(), protocolProvider);
        this.startThreadPools();
        this.services.add(service);
    }

    public synchronized void unbind(Service service) {
        ProtocolAcceptor acceptor = this.findProtocolAcceptor(service.getTransportType());
        try {
            acceptor.unbind(service.getAddress());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            acceptor.unbind(service.getAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.services.remove(service);
        this.stopThreadPools();
    }

    public synchronized void unbindAll() {
        Iterator it = new HashSet(this.services).iterator();
        while (it.hasNext()) {
            Service s = (Service)it.next();
            this.unbind(s);
        }
    }

    public IoAcceptor getIoAcceptor(TransportType transportType) {
        return this.findIoAcceptor(transportType);
    }

    public ProtocolAcceptor getProtocolAcceptor(TransportType transportType) {
        return this.findProtocolAcceptor(transportType);
    }

    public synchronized Set getAllServices() {
        return new HashSet(this.services);
    }

    public synchronized Set getServices(String name) {
        HashSet<Service> result = new HashSet<Service>();
        Iterator it = this.services.iterator();
        while (it.hasNext()) {
            Service s = (Service)it.next();
            if (!name.equals(s.getName())) continue;
            result.add(s);
        }
        return result;
    }

    public Set getServices(TransportType transportType) {
        HashSet<Service> result = new HashSet<Service>();
        Iterator it = this.services.iterator();
        while (it.hasNext()) {
            Service s = (Service)it.next();
            if (s.getTransportType() != transportType) continue;
            result.add(s);
        }
        return result;
    }

    public Set getServices(int port) {
        HashSet<Service> result = new HashSet<Service>();
        Iterator it = this.services.iterator();
        while (it.hasNext()) {
            Service s = (Service)it.next();
            SocketAddress addr = s.getAddress();
            int servicePort = addr instanceof InetSocketAddress ? ((InetSocketAddress)addr).getPort() : (addr instanceof VmPipeAddress ? ((VmPipeAddress)addr).getPort() : -1);
            if (servicePort != port) continue;
            result.add(s);
        }
        return result;
    }

    protected IoAcceptor findIoAcceptor(TransportType transportType) {
        if (transportType == TransportType.SOCKET) {
            return this.socketIoAcceptor;
        }
        if (transportType == TransportType.DATAGRAM) {
            return this.datagramIoAcceptor;
        }
        throw new IllegalArgumentException("Unsupported transport type: " + transportType);
    }

    protected ProtocolAcceptor findProtocolAcceptor(TransportType transportType) {
        if (transportType == TransportType.SOCKET) {
            return this.socketProtocolAcceptor;
        }
        if (transportType == TransportType.DATAGRAM) {
            return this.datagramProtocolAcceptor;
        }
        if (transportType == TransportType.VM_PIPE) {
            return this.vmPipeAcceptor;
        }
        throw new IllegalArgumentException("Unsupported transport type: " + transportType);
    }

    private void startThreadPools() {
        if (!this.services.isEmpty()) {
            return;
        }
        this.ioThreadPoolFilter.start();
        this.protocolThreadPoolFilter.start();
    }

    private void stopThreadPools() {
        if (!this.services.isEmpty()) {
            return;
        }
        this.ioThreadPoolFilter.stop();
        this.protocolThreadPoolFilter.stop();
    }
}

