/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.Session;

public abstract class BaseSession
implements Session {
    private final Map attributes = new HashMap();
    private long readBytes;
    private long writtenBytes;
    private long writtenWriteRequests;
    private long lastReadTime = this.lastWriteTime = System.currentTimeMillis();
    private long lastWriteTime;
    private boolean idleForBoth;
    private boolean idleForRead;
    private boolean idleForWrite;

    protected BaseSession() {
    }

    public void close() {
        this.close(false);
    }

    public Object getAttachment() {
        return this.attributes.get("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttachment(Object attachment) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.put("", attachment);
        }
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setAttribute(String key, Object value) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAttribute(String key) {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAttributeKeys() {
        Map map = this.attributes;
        synchronized (map) {
            return this.attributes.keySet();
        }
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    public long getWrittenWriteRequests() {
        return this.writtenWriteRequests;
    }

    public void increaseReadBytes(int increment) {
        this.readBytes += (long)increment;
        this.lastReadTime = System.currentTimeMillis();
    }

    public void increaseWrittenBytes(int increment) {
        this.writtenBytes += (long)increment;
        this.lastWriteTime = System.currentTimeMillis();
    }

    public void increaseWrittenWriteRequests() {
        ++this.writtenWriteRequests;
    }

    public long getLastIoTime() {
        return Math.max(this.lastReadTime, this.lastWriteTime);
    }

    public long getLastReadTime() {
        return this.lastReadTime;
    }

    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public boolean isIdle(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    public void setIdle(IdleStatus status, boolean value) {
        if (status == IdleStatus.BOTH_IDLE) {
            this.idleForBoth = value;
        } else if (status == IdleStatus.READER_IDLE) {
            this.idleForRead = value;
        } else if (status == IdleStatus.WRITER_IDLE) {
            this.idleForWrite = value;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + status);
        }
    }
}

