/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.mina.common.ByteBufferHexDumper;
import org.apache.mina.util.Stack;

public abstract class ByteBuffer {
    private static final int MINIMUM_CAPACITY = 1;
    private static final Stack containerStack = new Stack();
    private static final Stack[] heapBufferStacks = new Stack[]{new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack()};
    private static final Stack[] directBufferStacks = new Stack[]{new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack(), new Stack()};

    public static ByteBuffer allocate(int capacity) {
        try {
            return ByteBuffer.allocate(capacity, true);
        }
        catch (OutOfMemoryError e) {
            return ByteBuffer.allocate(capacity, false);
        }
    }

    public static ByteBuffer allocate(int capacity, boolean direct) {
        java.nio.ByteBuffer nioBuffer = ByteBuffer.allocate0(capacity, direct);
        DefaultByteBuffer buf = ByteBuffer.allocateContainer();
        buf.init(nioBuffer);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DefaultByteBuffer allocateContainer() {
        DefaultByteBuffer buf;
        Stack stack = containerStack;
        synchronized (stack) {
            buf = (DefaultByteBuffer)containerStack.pop();
        }
        if (buf == null) {
            buf = new DefaultByteBuffer();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static java.nio.ByteBuffer allocate0(int capacity, boolean direct) {
        java.nio.ByteBuffer buf;
        Stack stack;
        Stack[] bufferStacks = direct ? directBufferStacks : heapBufferStacks;
        int idx = ByteBuffer.getBufferStackIndex(bufferStacks, capacity);
        Stack stack2 = stack = bufferStacks[idx];
        synchronized (stack2) {
            buf = (java.nio.ByteBuffer)stack.pop();
        }
        if (buf == null) {
            buf = direct ? java.nio.ByteBuffer.allocateDirect(1 << idx) : java.nio.ByteBuffer.allocate(1 << idx);
        }
        buf.clear();
        buf.order(ByteOrder.BIG_ENDIAN);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release0(java.nio.ByteBuffer buf) {
        Stack stack;
        Stack[] bufferStacks = buf.isDirect() ? directBufferStacks : heapBufferStacks;
        Stack stack2 = stack = bufferStacks[ByteBuffer.getBufferStackIndex(bufferStacks, buf.capacity())];
        synchronized (stack2) {
            stack.push(buf);
        }
    }

    public static ByteBuffer wrap(java.nio.ByteBuffer nioBuffer) {
        DefaultByteBuffer buf = ByteBuffer.allocateContainer();
        buf.init(nioBuffer);
        return buf;
    }

    public static ByteBuffer wrap(byte[] byteArray) {
        return ByteBuffer.wrap(java.nio.ByteBuffer.wrap(byteArray));
    }

    public static ByteBuffer wrap(byte[] byteArray, int offset, int length) {
        return ByteBuffer.wrap(java.nio.ByteBuffer.wrap(byteArray, offset, length));
    }

    private static int getBufferStackIndex(Stack[] bufferStacks, int size) {
        int stackIdx = 0;
        for (int targetSize = 1; size > targetSize; targetSize <<= 1) {
            if (++stackIdx < bufferStacks.length) continue;
            throw new IllegalArgumentException("Buffer size is too big: " + size);
        }
        return stackIdx;
    }

    protected ByteBuffer() {
    }

    public abstract void acquire();

    public abstract void release();

    public abstract java.nio.ByteBuffer buf();

    public abstract boolean isDirect();

    public abstract int capacity();

    public abstract boolean isAutoExpand();

    public abstract ByteBuffer setAutoExpand(boolean var1);

    public abstract int position();

    public abstract ByteBuffer position(int var1);

    public abstract int limit();

    public abstract ByteBuffer limit(int var1);

    public abstract ByteBuffer mark();

    public abstract ByteBuffer reset();

    public abstract ByteBuffer clear();

    public abstract ByteBuffer flip();

    public abstract ByteBuffer rewind();

    public abstract int remaining();

    public abstract boolean hasRemaining();

    public abstract byte get();

    public abstract short getUnsigned();

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public abstract short getUnsigned(int var1);

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer get(byte[] var1, int var2, int var3);

    public abstract ByteBuffer get(byte[] var1);

    public abstract ByteBuffer put(java.nio.ByteBuffer var1);

    public abstract ByteBuffer put(ByteBuffer var1);

    public abstract ByteBuffer put(byte[] var1, int var2, int var3);

    public abstract ByteBuffer put(byte[] var1);

    public abstract ByteBuffer compact();

    public abstract String toString();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract int compareTo(ByteBuffer var1);

    public abstract ByteOrder order();

    public abstract ByteBuffer order(ByteOrder var1);

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract CharBuffer asCharBuffer();

    public abstract short getShort();

    public abstract int getUnsignedShort();

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public abstract int getUnsignedShort(int var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ShortBuffer asShortBuffer();

    public abstract int getInt();

    public abstract long getUnsignedInt();

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public abstract long getUnsignedInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract IntBuffer asIntBuffer();

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract LongBuffer asLongBuffer();

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract FloatBuffer asFloatBuffer();

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public abstract DoubleBuffer asDoubleBuffer();

    public abstract String getHexDump();

    public abstract String getString(CharsetDecoder var1) throws CharacterCodingException;

    public abstract String getString(int var1, CharsetDecoder var2) throws CharacterCodingException;

    public abstract ByteBuffer putString(CharSequence var1, CharsetEncoder var2) throws CharacterCodingException;

    public abstract ByteBuffer putString(CharSequence var1, int var2, CharsetEncoder var3) throws CharacterCodingException;

    public abstract ByteBuffer skip(int var1);

    public abstract ByteBuffer fill(byte var1, int var2);

    public abstract ByteBuffer fillAndReset(byte var1, int var2);

    public abstract ByteBuffer fill(int var1);

    public abstract ByteBuffer fillAndReset(int var1);

    private static class DefaultByteBuffer
    extends ByteBuffer {
        private java.nio.ByteBuffer buf;
        private int refCount = 1;
        private boolean autoExpand;

        protected DefaultByteBuffer() {
        }

        private synchronized void init(java.nio.ByteBuffer buf) {
            this.buf = buf;
            this.autoExpand = false;
            this.refCount = 1;
        }

        public synchronized void acquire() {
            if (this.refCount <= 0) {
                throw new IllegalStateException("Already released buffer.");
            }
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Object object = this;
            synchronized (object) {
                if (this.refCount <= 0) {
                    this.refCount = 0;
                    throw new IllegalStateException("Already released buffer.  You released the buffer too many times.");
                }
                --this.refCount;
                if (this.refCount > 0) {
                    return;
                }
            }
            ByteBuffer.release0(this.buf);
            object = containerStack;
            synchronized (object) {
                containerStack.push(this);
            }
        }

        public java.nio.ByteBuffer buf() {
            return this.buf;
        }

        public boolean isDirect() {
            return this.buf.isDirect();
        }

        public boolean isReadOnly() {
            return this.buf.isReadOnly();
        }

        public boolean isAutoExpand() {
            return this.autoExpand;
        }

        public ByteBuffer setAutoExpand(boolean autoExpand) {
            this.autoExpand = autoExpand;
            return this;
        }

        public int capacity() {
            return this.buf.capacity();
        }

        public int position() {
            return this.buf.position();
        }

        public ByteBuffer position(int newPosition) {
            this.autoExpand(newPosition, 0);
            this.buf.position(newPosition);
            return this;
        }

        public int limit() {
            return this.buf.limit();
        }

        public ByteBuffer limit(int newLimit) {
            this.autoExpand(newLimit, 0);
            this.buf.limit(newLimit);
            return this;
        }

        public ByteBuffer mark() {
            this.buf.mark();
            return this;
        }

        public ByteBuffer reset() {
            this.buf.reset();
            return this;
        }

        public ByteBuffer clear() {
            this.buf.clear();
            return this;
        }

        public ByteBuffer flip() {
            this.buf.flip();
            return this;
        }

        public ByteBuffer rewind() {
            this.buf.rewind();
            return this;
        }

        public int remaining() {
            return this.buf.remaining();
        }

        public boolean hasRemaining() {
            return this.buf.hasRemaining();
        }

        public byte get() {
            return this.buf.get();
        }

        public short getUnsigned() {
            return (short)(this.get() & 0xFF);
        }

        public ByteBuffer put(byte b) {
            this.autoExpand(1);
            this.buf.put(b);
            return this;
        }

        public byte get(int index) {
            return this.buf.get(index);
        }

        public short getUnsigned(int index) {
            return (short)(this.get(index) & 0xFF);
        }

        public ByteBuffer put(int index, byte b) {
            this.autoExpand(index, 1);
            this.buf.put(index, b);
            return this;
        }

        public ByteBuffer get(byte[] dst, int offset, int length) {
            this.buf.get(dst, offset, length);
            return this;
        }

        public ByteBuffer get(byte[] dst) {
            this.buf.get(dst);
            return this;
        }

        public ByteBuffer put(java.nio.ByteBuffer src) {
            this.autoExpand(src.remaining());
            this.buf.put(src);
            return this;
        }

        public ByteBuffer put(ByteBuffer src) {
            this.autoExpand(src.remaining());
            this.buf.put(src.buf());
            return this;
        }

        public ByteBuffer put(byte[] src, int offset, int length) {
            this.autoExpand(length);
            this.buf.put(src, offset, length);
            return this;
        }

        public ByteBuffer put(byte[] src) {
            this.autoExpand(src.length);
            this.buf.put(src);
            return this;
        }

        public ByteBuffer compact() {
            this.buf.compact();
            return this;
        }

        public String toString() {
            return this.buf.toString();
        }

        public int hashCode() {
            return this.buf.hashCode();
        }

        public boolean equals(Object ob) {
            if (!(ob instanceof ByteBuffer)) {
                return false;
            }
            ByteBuffer that = (ByteBuffer)ob;
            return this.buf.equals(that.buf());
        }

        public int compareTo(ByteBuffer that) {
            return this.buf.compareTo(that.buf());
        }

        public ByteOrder order() {
            return this.buf.order();
        }

        public ByteBuffer order(ByteOrder bo) {
            this.buf.order(bo);
            return this;
        }

        public char getChar() {
            return this.buf.getChar();
        }

        public ByteBuffer putChar(char value) {
            this.autoExpand(2);
            this.buf.putChar(value);
            return this;
        }

        public char getChar(int index) {
            return this.buf.getChar(index);
        }

        public ByteBuffer putChar(int index, char value) {
            this.autoExpand(index, 2);
            this.buf.putChar(index, value);
            return this;
        }

        public CharBuffer asCharBuffer() {
            return this.buf.asCharBuffer();
        }

        public short getShort() {
            return this.buf.getShort();
        }

        public int getUnsignedShort() {
            return this.getShort() & 0xFFFF;
        }

        public ByteBuffer putShort(short value) {
            this.autoExpand(2);
            this.buf.putShort(value);
            return this;
        }

        public short getShort(int index) {
            return this.buf.getShort(index);
        }

        public int getUnsignedShort(int index) {
            return this.getShort(index) & 0xFFFF;
        }

        public ByteBuffer putShort(int index, short value) {
            this.autoExpand(index, 2);
            this.buf.putShort(index, value);
            return this;
        }

        public ShortBuffer asShortBuffer() {
            return this.buf.asShortBuffer();
        }

        public int getInt() {
            return this.buf.getInt();
        }

        public long getUnsignedInt() {
            return (long)this.getInt() & 0xFFFFFFFFL;
        }

        public ByteBuffer putInt(int value) {
            this.autoExpand(4);
            this.buf.putInt(value);
            return this;
        }

        public int getInt(int index) {
            return this.buf.getInt(index);
        }

        public long getUnsignedInt(int index) {
            return (long)this.getInt(index) & 0xFFFFFFFFL;
        }

        public ByteBuffer putInt(int index, int value) {
            this.autoExpand(index, 4);
            this.buf.putInt(index, value);
            return this;
        }

        public IntBuffer asIntBuffer() {
            return this.buf.asIntBuffer();
        }

        public long getLong() {
            return this.buf.getLong();
        }

        public ByteBuffer putLong(long value) {
            this.autoExpand(8);
            this.buf.putLong(value);
            return this;
        }

        public long getLong(int index) {
            return this.buf.getLong(index);
        }

        public ByteBuffer putLong(int index, long value) {
            this.autoExpand(index, 8);
            this.buf.putLong(index, value);
            return this;
        }

        public LongBuffer asLongBuffer() {
            return this.buf.asLongBuffer();
        }

        public float getFloat() {
            return this.buf.getFloat();
        }

        public ByteBuffer putFloat(float value) {
            this.autoExpand(4);
            this.buf.putFloat(value);
            return this;
        }

        public float getFloat(int index) {
            return this.buf.getFloat(index);
        }

        public ByteBuffer putFloat(int index, float value) {
            this.autoExpand(index, 4);
            this.buf.putFloat(index, value);
            return this;
        }

        public FloatBuffer asFloatBuffer() {
            return this.buf.asFloatBuffer();
        }

        public double getDouble() {
            return this.buf.getDouble();
        }

        public ByteBuffer putDouble(double value) {
            this.autoExpand(8);
            this.buf.putDouble(value);
            return this;
        }

        public double getDouble(int index) {
            return this.buf.getDouble(index);
        }

        public ByteBuffer putDouble(int index, double value) {
            this.autoExpand(index, 8);
            this.buf.putDouble(index, value);
            return this;
        }

        public DoubleBuffer asDoubleBuffer() {
            return this.buf.asDoubleBuffer();
        }

        public String getHexDump() {
            return ByteBufferHexDumper.getHexdump(this);
        }

        public String getString(CharsetDecoder decoder) throws CharacterCodingException {
            CoderResult cr;
            int end;
            if (!this.buf.hasRemaining()) {
                return "";
            }
            boolean utf16 = decoder.charset().name().startsWith("UTF-16");
            int oldPos = this.buf.position();
            int oldLimit = this.buf.limit();
            if (!utf16) {
                while (this.buf.hasRemaining() && this.buf.get() != 0) {
                }
                end = this.buf.position();
                if (end == oldLimit) {
                    this.buf.limit(end);
                } else {
                    this.buf.limit(end - 1);
                }
            } else {
                while (this.buf.remaining() >= 2 && (this.buf.get() != 0 || this.buf.get() != 0)) {
                }
                end = this.buf.position();
                if (end == oldLimit || end == oldLimit - 1) {
                    this.buf.limit(end);
                } else {
                    this.buf.limit(end - 2);
                }
            }
            this.buf.position(oldPos);
            decoder.reset();
            int expectedLength = (int)((float)this.buf.remaining() * decoder.averageCharsPerByte());
            CharBuffer out = CharBuffer.allocate(expectedLength);
            while (!(cr = this.buf.hasRemaining() ? decoder.decode(this.buf, out, true) : decoder.flush(out)).isUnderflow()) {
                if (cr.isOverflow()) {
                    CharBuffer o = CharBuffer.allocate(out.capacity() + expectedLength);
                    out.flip();
                    o.put(out);
                    out = o;
                    continue;
                }
                cr.throwException();
            }
            this.buf.limit(oldLimit);
            this.buf.position(end);
            return out.flip().toString();
        }

        public String getString(int fieldSize, CharsetDecoder decoder) throws CharacterCodingException {
            CoderResult cr;
            int i;
            int end;
            DefaultByteBuffer.checkFieldSize(fieldSize);
            if (fieldSize == 0) {
                return "";
            }
            if (!this.buf.hasRemaining()) {
                return "";
            }
            boolean utf16 = decoder.charset().name().startsWith("UTF-16");
            if (utf16 && (fieldSize & 1) != 0) {
                throw new IllegalArgumentException("fieldSize is not even.");
            }
            int oldPos = this.buf.position();
            int oldLimit = this.buf.limit();
            if (oldLimit < (end = this.buf.position() + fieldSize)) {
                throw new BufferUnderflowException();
            }
            if (!utf16) {
                for (i = 0; i < fieldSize && this.buf.get() != 0; ++i) {
                }
                if (i == fieldSize) {
                    this.buf.limit(end);
                } else {
                    this.buf.limit(this.buf.position() - 1);
                }
            } else {
                for (i = 0; i < fieldSize && (this.buf.get() != 0 || this.buf.get() != 0); i += 2) {
                }
                if (i == fieldSize) {
                    this.buf.limit(end);
                } else {
                    this.buf.limit(this.buf.position() - 2);
                }
            }
            this.buf.position(oldPos);
            decoder.reset();
            int expectedLength = (int)((float)this.buf.remaining() * decoder.averageCharsPerByte());
            CharBuffer out = CharBuffer.allocate(expectedLength);
            while (!(cr = this.buf.hasRemaining() ? decoder.decode(this.buf, out, true) : decoder.flush(out)).isUnderflow()) {
                if (cr.isOverflow()) {
                    CharBuffer o = CharBuffer.allocate(out.capacity() + expectedLength);
                    out.flip();
                    o.put(out);
                    out = o;
                    continue;
                }
                cr.throwException();
            }
            this.buf.limit(oldLimit);
            this.buf.position(end);
            return out.flip().toString();
        }

        public ByteBuffer putString(CharSequence val, int fieldSize, CharsetEncoder encoder) throws CharacterCodingException {
            CoderResult cr;
            int end;
            DefaultByteBuffer.checkFieldSize(fieldSize);
            if (fieldSize == 0) {
                return this;
            }
            this.autoExpand(fieldSize);
            boolean utf16 = encoder.charset().name().startsWith("UTF-16");
            if (utf16 && (fieldSize & 1) != 0) {
                throw new IllegalArgumentException("fieldSize is not even.");
            }
            int oldLimit = this.buf.limit();
            if (oldLimit < (end = this.buf.position() + fieldSize)) {
                throw new BufferOverflowException();
            }
            if (val.length() == 0) {
                if (!utf16) {
                    this.buf.put((byte)0);
                } else {
                    this.buf.put((byte)0);
                    this.buf.put((byte)0);
                }
                this.buf.position(end);
                return this;
            }
            CharBuffer in = CharBuffer.wrap(val);
            this.buf.limit(end);
            encoder.reset();
            while (!(cr = in.hasRemaining() ? encoder.encode(in, this.buf(), true) : encoder.flush(this.buf())).isUnderflow() && !cr.isOverflow()) {
                cr.throwException();
            }
            this.buf.limit(oldLimit);
            if (this.buf.position() < end) {
                if (!utf16) {
                    this.buf.put((byte)0);
                } else {
                    this.buf.put((byte)0);
                    this.buf.put((byte)0);
                }
            }
            this.buf.position(end);
            return this;
        }

        public ByteBuffer putString(CharSequence val, CharsetEncoder encoder) throws CharacterCodingException {
            CoderResult cr;
            if (val.length() == 0) {
                return this;
            }
            CharBuffer in = CharBuffer.wrap(val);
            int expectedLength = (int)((float)in.remaining() * encoder.averageBytesPerChar());
            encoder.reset();
            while (!(cr = in.hasRemaining() ? encoder.encode(in, this.buf(), true) : encoder.flush(this.buf())).isUnderflow()) {
                if (cr.isOverflow() && this.autoExpand) {
                    this.autoExpand(expectedLength);
                    continue;
                }
                cr.throwException();
            }
            return this;
        }

        public ByteBuffer skip(int size) {
            this.autoExpand(size);
            return this.position(this.position() + size);
        }

        public ByteBuffer fill(byte value, int size) {
            int intValue;
            this.autoExpand(size);
            int q = size >>> 3;
            int r = size & 7;
            if (q > 0) {
                intValue = value | value << 8 | value << 16 | value << 24;
                long longValue = intValue;
                longValue <<= 32;
                longValue |= (long)intValue;
                for (int i = q; i > 0; --i) {
                    this.buf.putLong(longValue);
                }
            }
            q = r >>> 2;
            r &= 3;
            if (q > 0) {
                intValue = value | value << 8 | value << 16 | value << 24;
                this.buf.putInt(intValue);
            }
            q = r >> 1;
            r &= 1;
            if (q > 0) {
                short shortValue = (short)(value | value << 8);
                this.buf.putShort(shortValue);
            }
            if (r > 0) {
                this.buf.put(value);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer fillAndReset(byte value, int size) {
            this.autoExpand(size);
            int pos = this.buf.position();
            try {
                this.fill(value, size);
            }
            finally {
                this.buf.position(pos);
            }
            return this;
        }

        public ByteBuffer fill(int size) {
            this.autoExpand(size);
            int q = size >>> 3;
            int r = size & 7;
            for (int i = q; i > 0; --i) {
                this.buf.putLong(0L);
            }
            q = r >>> 2;
            r &= 3;
            if (q > 0) {
                this.buf.putInt(0);
            }
            q = r >> 1;
            r &= 1;
            if (q > 0) {
                this.buf.putShort((short)0);
            }
            if (r > 0) {
                this.buf.put((byte)0);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer fillAndReset(int size) {
            this.autoExpand(size);
            int pos = this.buf.position();
            try {
                this.fill(size);
            }
            finally {
                this.buf.position(pos);
            }
            return this;
        }

        private void autoExpand(int delta) {
            int limit;
            int pos;
            int end;
            if (this.autoExpand && (end = (pos = this.buf.position()) + delta) > (limit = this.buf.limit())) {
                this.ensureCapacity(end);
                this.buf.limit(end);
            }
        }

        private void autoExpand(int pos, int delta) {
            int limit;
            int end;
            if (this.autoExpand && (end = pos + delta) > (limit = this.buf.limit())) {
                this.ensureCapacity(end);
                this.buf.limit(end);
            }
        }

        private void ensureCapacity(int requestedCapacity) {
            int newCapacity;
            if (requestedCapacity <= this.buf.capacity()) {
                return;
            }
            for (newCapacity = 1; newCapacity < requestedCapacity; newCapacity <<= 1) {
            }
            java.nio.ByteBuffer oldBuf = this.buf;
            java.nio.ByteBuffer newBuf = ByteBuffer.allocate0(newCapacity, this.isDirect());
            newBuf.clear();
            newBuf.order(oldBuf.order());
            int pos = oldBuf.position();
            int limit = oldBuf.limit();
            oldBuf.clear();
            newBuf.put(oldBuf);
            newBuf.position(0);
            newBuf.limit(limit);
            newBuf.position(pos);
            this.buf = newBuf;
            ByteBuffer.release0(oldBuf);
        }

        private static void checkFieldSize(int fieldSize) {
            if (fieldSize < 0) {
                throw new IllegalArgumentException("fieldSize cannot be negative: " + fieldSize);
            }
        }
    }
}

