/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.echoserver;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.SessionConfig;
import org.apache.mina.io.IoHandlerAdapter;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.socket.SocketSessionConfig;

public class EchoProtocolHandler
extends IoHandlerAdapter {
    public void sessionCreated(IoSession session) {
        SessionConfig cfg = session.getConfig();
        if (cfg instanceof SocketSessionConfig) {
            ((SocketSessionConfig)cfg).setSessionReceiveBufferSize(2048);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        session.close();
    }

    public void dataRead(IoSession session, ByteBuffer rb) {
        ByteBuffer wb = ByteBuffer.allocate(rb.remaining());
        wb.put(rb);
        wb.flip();
        session.write(wb, null);
    }
}

