/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import java.util.logging.Level;
import org.apache.mina.examples.sumup.message.AddMessage;
import org.apache.mina.examples.sumup.message.ResultMessage;
import org.apache.mina.protocol.ProtocolHandlerAdapter;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.filter.ProtocolLoggingFilter;
import org.apache.mina.util.SessionLog;

public class ClientSessionHandler
extends ProtocolHandlerAdapter {
    private final int[] values;
    private boolean finished;

    public ClientSessionHandler(int[] values) {
        this.values = values;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void sessionCreated(ProtocolSession session) {
        session.getFilterChain().addLast("logger", new ProtocolLoggingFilter());
    }

    public void sessionOpened(ProtocolSession session) {
        for (int i = 0; i < this.values.length; ++i) {
            AddMessage m = new AddMessage();
            m.setSequence(i);
            m.setValue(this.values[i]);
            session.write(m);
        }
    }

    public void messageReceived(ProtocolSession session, Object message) {
        ResultMessage rm = (ResultMessage)message;
        if (rm.isOk()) {
            if (rm.getSequence() == this.values.length - 1) {
                SessionLog.log(Level.INFO, session, "The sum: " + rm.getValue());
                session.close();
                this.finished = true;
            }
        } else {
            SessionLog.log(Level.WARNING, session, "Server error, disconnecting...");
            session.close();
            this.finished = true;
        }
    }

    public void exceptionCaught(ProtocolSession session, Throwable cause) {
        session.close();
    }
}

