/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.io.IoFilter;
import org.apache.mina.io.IoFilterChain;
import org.apache.mina.io.IoHandler;
import org.apache.mina.io.IoSession;

public abstract class AbstractIoFilterChain
implements IoFilterChain {
    private final Map name2entry = new HashMap();
    private final Map filter2entry = new IdentityHashMap();
    private final Entry head = new Entry(null, null, "head", this.createHeadFilter());
    private final Entry tail = new Entry(this.head, null, "tail", this.createTailFilter());

    protected AbstractIoFilterChain() {
        this.head.nextEntry = this.tail;
    }

    protected IoFilter createHeadFilter() {
        return new IoFilter(){

            public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
                nextFilter.sessionOpened(session);
            }

            public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
                nextFilter.sessionClosed(session);
            }

            public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
                nextFilter.sessionIdle(session, status);
            }

            public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
                nextFilter.exceptionCaught(session, cause);
            }

            public void dataRead(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf) throws Exception {
                nextFilter.dataRead(session, buf);
            }

            public void dataWritten(IoFilter.NextFilter nextFilter, IoSession session, Object marker) throws Exception {
                nextFilter.dataWritten(session, marker);
            }

            public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf, Object marker) throws Exception {
                AbstractIoFilterChain.this.doWrite(session, buf, marker);
            }
        };
    }

    protected IoFilter createTailFilter() {
        return new IoFilter(){

            public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
                session.getHandler().sessionOpened(session);
            }

            public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
                session.getHandler().sessionClosed(session);
            }

            public void sessionIdle(IoFilter.NextFilter nextFilter, IoSession session, IdleStatus status) throws Exception {
                session.getHandler().sessionIdle(session, status);
            }

            public void exceptionCaught(IoFilter.NextFilter nextFilter, IoSession session, Throwable cause) throws Exception {
                session.getHandler().exceptionCaught(session, cause);
            }

            public void dataRead(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf) throws Exception {
                IoHandler handler = session.getHandler();
                handler.dataRead(session, buf);
                buf.release();
            }

            public void dataWritten(IoFilter.NextFilter nextFilter, IoSession session, Object marker) throws Exception {
                session.getHandler().dataWritten(session, marker);
            }

            public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, ByteBuffer buf, Object marker) throws Exception {
                nextFilter.filterWrite(session, buf, marker);
            }
        };
    }

    public IoFilter getChild(String name) {
        Entry e = (Entry)this.name2entry.get(name);
        if (e == null) {
            return null;
        }
        return e.filter;
    }

    public synchronized void addFirst(String name, IoFilter filter) {
        this.checkAddable(name);
        this.register(this.head, name, filter);
    }

    public synchronized void addLast(String name, IoFilter filter) {
        this.checkAddable(name);
        this.register(this.tail.prevEntry, name, filter);
    }

    public synchronized void addBefore(String baseName, String name, IoFilter filter) {
        Entry baseEntry = this.checkOldName(baseName);
        this.checkAddable(name);
        this.register(baseEntry, name, filter);
    }

    public synchronized void addAfter(String baseName, String name, IoFilter filter) {
        Entry baseEntry = this.checkOldName(baseName);
        this.checkAddable(name);
        this.register(baseEntry.prevEntry, name, filter);
    }

    public synchronized IoFilter remove(String name) {
        Entry entry = this.checkOldName(name);
        Entry prevEntry = entry.prevEntry;
        Entry nextEntry = entry.nextEntry;
        prevEntry.nextEntry = nextEntry;
        nextEntry.prevEntry = prevEntry;
        this.name2entry.remove(name);
        IoFilter filter = entry.filter;
        this.filter2entry.remove(filter);
        return filter;
    }

    public synchronized void clear() {
        Iterator it = new ArrayList(this.name2entry.keySet()).iterator();
        while (it.hasNext()) {
            this.remove((String)it.next());
        }
    }

    private void register(Entry prevEntry, String name, IoFilter filter) {
        Entry newEntry = new Entry(prevEntry, prevEntry.nextEntry, name, filter);
        prevEntry.nextEntry.prevEntry = newEntry;
        prevEntry.nextEntry = newEntry;
        this.name2entry.put(name, newEntry);
        this.filter2entry.put(filter, newEntry);
    }

    private Entry checkOldName(String baseName) {
        Entry e = (Entry)this.name2entry.get(baseName);
        if (e == null) {
            throw new IllegalArgumentException("Unknown interceptor name:" + baseName);
        }
        return e;
    }

    private void checkAddable(String name) {
        if (this.name2entry.containsKey(name)) {
            throw new IllegalArgumentException("Other interceptor is using name '" + name + "'");
        }
    }

    public void sessionOpened(IoSession session) {
        Entry head = this.head;
        this.callNextSessionOpened(head, session);
    }

    private void callNextSessionOpened(Entry entry, IoSession session) {
        try {
            entry.filter.sessionOpened(entry.nextFilter, session);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void sessionClosed(IoSession session) {
        Entry head = this.head;
        this.callNextSessionClosed(head, session);
    }

    private void callNextSessionClosed(Entry entry, IoSession session) {
        try {
            entry.filter.sessionClosed(entry.nextFilter, session);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        Entry head = this.head;
        this.callNextSessionIdle(head, session, status);
    }

    private void callNextSessionIdle(Entry entry, IoSession session, IdleStatus status) {
        try {
            entry.filter.sessionIdle(entry.nextFilter, session, status);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void dataRead(IoSession session, ByteBuffer buf) {
        Entry head = this.head;
        this.callNextDataRead(head, session, buf);
    }

    private void callNextDataRead(Entry entry, IoSession session, ByteBuffer buf) {
        try {
            entry.filter.dataRead(entry.nextFilter, session, buf);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void dataWritten(IoSession session, Object marker) {
        Entry head = this.head;
        this.callNextDataWritten(head, session, marker);
    }

    private void callNextDataWritten(Entry entry, IoSession session, Object marker) {
        try {
            entry.filter.dataWritten(entry.nextFilter, session, marker);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        Entry head = this.head;
        this.callNextExceptionCaught(head, session, cause);
    }

    private void callNextExceptionCaught(Entry entry, IoSession session, Throwable cause) {
        try {
            entry.filter.exceptionCaught(entry.nextFilter, session, cause);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void filterWrite(IoSession session, ByteBuffer buf, Object marker) {
        Entry tail = this.tail;
        this.callPreviousFilterWrite(tail, session, buf, marker);
    }

    private void callPreviousFilterWrite(Entry entry, IoSession session, ByteBuffer buf, Object marker) {
        if (buf == null) {
            return;
        }
        try {
            entry.filter.filterWrite(entry.nextFilter, session, buf, marker);
        }
        catch (Throwable e) {
            this.exceptionCaught(session, e);
        }
    }

    public List getChildren() {
        ArrayList<IoFilter> list = new ArrayList<IoFilter>();
        Entry e = this.head.nextEntry;
        while (e != this.tail) {
            list.add(e.filter);
            e = e.nextEntry;
        }
        return list;
    }

    public List getChildrenReversed() {
        ArrayList<IoFilter> list = new ArrayList<IoFilter>();
        Entry e = this.tail.prevEntry;
        while (e != this.head) {
            list.add(e.filter);
            e = e.prevEntry;
        }
        return list;
    }

    protected abstract void doWrite(IoSession var1, ByteBuffer var2, Object var3);

    private class Entry {
        private Entry prevEntry;
        private Entry nextEntry;
        private final String name;
        private final IoFilter filter;
        private final IoFilter.NextFilter nextFilter;

        private Entry(Entry prevEntry, Entry nextEntry, String name, IoFilter filter) {
            if (filter == null) {
                throw new NullPointerException("filter");
            }
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.prevEntry = prevEntry;
            this.nextEntry = nextEntry;
            this.name = name;
            this.filter = filter;
            this.nextFilter = new IoFilter.NextFilter(){

                public void sessionOpened(IoSession session) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionOpened(nextEntry, session);
                }

                public void sessionClosed(IoSession session) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionClosed(nextEntry, session);
                }

                public void sessionIdle(IoSession session, IdleStatus status) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractIoFilterChain.this.callNextSessionIdle(nextEntry, session, status);
                }

                public void exceptionCaught(IoSession session, Throwable cause) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractIoFilterChain.this.callNextExceptionCaught(nextEntry, session, cause);
                }

                public void dataRead(IoSession session, ByteBuffer buf) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractIoFilterChain.this.callNextDataRead(nextEntry, session, buf);
                }

                public void dataWritten(IoSession session, Object marker) {
                    Entry nextEntry = Entry.this.nextEntry;
                    AbstractIoFilterChain.this.callNextDataWritten(nextEntry, session, marker);
                }

                public void filterWrite(IoSession session, ByteBuffer buf, Object marker) {
                    Entry nextEntry = Entry.this.prevEntry;
                    AbstractIoFilterChain.this.callPreviousFilterWrite(nextEntry, session, buf, marker);
                }
            };
        }

        public String getName() {
            return this.name;
        }

        public IoFilter getFilter() {
            return this.filter;
        }
    }
}

