/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.datagram;

import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.apache.mina.common.BaseSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.SessionConfig;
import org.apache.mina.common.TransportType;
import org.apache.mina.io.IoFilterChain;
import org.apache.mina.io.IoHandler;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.IoSessionFilterChain;
import org.apache.mina.io.IoSessionManager;
import org.apache.mina.io.IoSessionManagerFilterChain;
import org.apache.mina.io.datagram.DatagramConnector;
import org.apache.mina.io.datagram.DatagramSessionConfig;
import org.apache.mina.util.Queue;

class DatagramSession
extends BaseSession
implements IoSession {
    private final IoSessionManagerFilterChain managerFilterChain;
    private final IoSessionFilterChain filterChain;
    private final DatagramChannel ch;
    private final DatagramSessionConfig config;
    private final Queue writeBufferQueue;
    private final Queue writeMarkerQueue;
    private final IoHandler handler;
    private final SocketAddress localAddress;
    private SocketAddress remoteAddress;
    private SelectionKey key;
    private boolean disposed;

    DatagramSession(IoSessionManagerFilterChain managerFilterChain, DatagramChannel ch, IoHandler defaultHandler) {
        this.managerFilterChain = managerFilterChain;
        this.filterChain = new IoSessionFilterChain(managerFilterChain);
        this.ch = ch;
        this.config = new DatagramSessionConfig(ch);
        this.writeBufferQueue = new Queue();
        this.writeMarkerQueue = new Queue();
        this.handler = defaultHandler;
        this.remoteAddress = ch.socket().getRemoteSocketAddress();
        this.localAddress = ch.socket().getLocalSocketAddress();
    }

    IoSessionManagerFilterChain getManagerFilterChain() {
        return this.managerFilterChain;
    }

    public IoFilterChain getFilterChain() {
        return this.filterChain;
    }

    DatagramChannel getChannel() {
        return this.ch;
    }

    SelectionKey getSelectionKey() {
        return this.key;
    }

    void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public IoHandler getHandler() {
        return this.handler;
    }

    synchronized void notifyClose() {
        if (!this.disposed) {
            this.disposed = true;
            this.notify();
        }
    }

    public synchronized void close(boolean wait) {
        if (this.disposed) {
            return;
        }
        IoSessionManager manager = this.managerFilterChain.getManager();
        if (manager instanceof DatagramConnector) {
            ((DatagramConnector)manager).closeSession(this);
            if (wait) {
                while (this.disposed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    Queue getWriteBufferQueue() {
        return this.writeBufferQueue;
    }

    Queue getWriteMarkerQueue() {
        return this.writeMarkerQueue;
    }

    public void write(ByteBuffer buf, Object marker) {
        this.filterChain.filterWrite(this, buf, marker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScheduledWriteRequests() {
        Queue queue = this.writeBufferQueue;
        synchronized (queue) {
            return this.writeBufferQueue.size();
        }
    }

    public TransportType getTransportType() {
        return TransportType.DATAGRAM;
    }

    public boolean isConnected() {
        return this.ch.isConnected();
    }

    public SessionConfig getConfig() {
        return this.config;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }
}

