/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.io.socket;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.apache.mina.common.BaseSessionManager;
import org.apache.mina.io.IoConnector;
import org.apache.mina.io.IoFilterChain;
import org.apache.mina.io.IoHandler;
import org.apache.mina.io.IoSession;
import org.apache.mina.io.IoSessionManagerFilterChain;
import org.apache.mina.io.socket.SocketIoProcessor;
import org.apache.mina.io.socket.SocketSession;
import org.apache.mina.io.socket.SocketSessionManagerFilterChain;
import org.apache.mina.util.ExceptionUtil;
import org.apache.mina.util.Queue;

public class SocketConnector
extends BaseSessionManager
implements IoConnector {
    private static volatile int nextId = 0;
    private final int id = nextId++;
    private final IoSessionManagerFilterChain filters = new SocketSessionManagerFilterChain(this);
    private Selector selector;
    private final Queue connectQueue = new Queue();
    private Worker worker;

    public IoSession connect(SocketAddress address, IoHandler handler) throws IOException {
        return this.connect(address, null, Integer.MAX_VALUE, handler);
    }

    public IoSession connect(SocketAddress address, SocketAddress localAddress, IoHandler handler) throws IOException {
        return this.connect(address, localAddress, Integer.MAX_VALUE, handler);
    }

    public IoSession connect(SocketAddress address, int timeout, IoHandler handler) throws IOException {
        return this.connect(address, null, timeout, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSession connect(SocketAddress address, SocketAddress localAddress, int timeout, IoHandler handler) throws IOException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (timeout <= 0) {
            throw new IllegalArgumentException("Illegal timeout: " + timeout);
        }
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + address.getClass());
        }
        if (localAddress != null && !(localAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected local address type: " + localAddress.getClass());
        }
        SocketChannel ch = SocketChannel.open();
        boolean success = false;
        try {
            ch.socket().setReuseAddress(true);
            if (localAddress != null) {
                ch.socket().bind(localAddress);
            }
            ch.configureBlocking(false);
            if (ch.connect(address)) {
                SocketSession session = this.newSession(ch, handler);
                success = true;
                SocketSession socketSession = session;
                return socketSession;
            }
            success = true;
        }
        finally {
            if (!success) {
                ch.close();
            }
        }
        ConnectionRequest request = new ConnectionRequest(ch, timeout, handler);
        Object object = this;
        synchronized (object) {
            Queue queue = this.connectQueue;
            synchronized (queue) {
                this.connectQueue.push(request);
            }
            this.startupWorker();
        }
        this.selector.wakeup();
        object = request;
        synchronized (object) {
            while (!request.done) {
                try {
                    request.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (request.exception != null) {
            ExceptionUtil.throwException(request.exception);
        }
        return request.session;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNew() {
        if (this.connectQueue.isEmpty()) {
            return;
        }
        while (true) {
            ConnectionRequest req;
            Queue queue = this.connectQueue;
            synchronized (queue) {
                req = (ConnectionRequest)this.connectQueue.pop();
            }
            if (req == null) break;
            SocketChannel ch = req.channel;
            try {
                ch.register(this.selector, 8, req);
            }
            catch (IOException e) {
                req.exception = e;
                ConnectionRequest connectionRequest = req;
                synchronized (connectionRequest) {
                    req.done = true;
                    req.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessions(Set keys) {
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            SelectionKey key = (SelectionKey)it.next();
            if (!key.isConnectable()) continue;
            SocketChannel ch = (SocketChannel)key.channel();
            ConnectionRequest entry = (ConnectionRequest)key.attachment();
            try {
                ch.finishConnect();
                SocketSession session = this.newSession(ch, entry.handler);
                entry.session = session;
            }
            catch (Throwable e) {
                entry.exception = e;
            }
            finally {
                key.cancel();
                if (entry.session == null) {
                    try {
                        ch.close();
                    }
                    catch (IOException e) {
                        this.exceptionMonitor.exceptionCaught(this, e);
                    }
                }
                ConnectionRequest e = entry;
                synchronized (e) {
                    entry.done = true;
                    entry.notify();
                }
            }
        }
        keys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTimedOutSessions(Set keys) {
        long currentTime = System.currentTimeMillis();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            ConnectionRequest entry;
            SelectionKey key = (SelectionKey)it.next();
            if (!key.isValid() || currentTime < (entry = (ConnectionRequest)key.attachment()).deadline) continue;
            entry.exception = new ConnectException();
            entry.done = true;
            ConnectionRequest connectionRequest = entry;
            synchronized (connectionRequest) {
                entry.notify();
            }
            key.cancel();
        }
    }

    private SocketSession newSession(SocketChannel ch, IoHandler handler) throws IOException {
        SocketSession session = new SocketSession(this.filters, ch, handler);
        try {
            handler.sessionCreated(session);
        }
        catch (Throwable e) {
            ExceptionUtil.throwException(e);
        }
        SocketIoProcessor.getInstance().addSession(session);
        return session;
    }

    public IoFilterChain getFilterChain() {
        return this.filters;
    }

    private static class ConnectionRequest {
        private final SocketChannel channel;
        private final long deadline;
        private final IoHandler handler;
        private SocketSession session;
        private boolean done;
        private Throwable exception;

        private ConnectionRequest(SocketChannel channel, int timeout, IoHandler handler) {
            this.channel = channel;
            this.deadline = System.currentTimeMillis() + (long)timeout * 1000L;
            this.handler = handler;
        }
    }

    private class Worker
    extends Thread {
        public Worker() {
            super("SocketConnector-" + SocketConnector.this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    do {
                        int nKeys = SocketConnector.this.selector.select(1000L);
                        SocketConnector.this.registerNew();
                        if (nKeys > 0) {
                            SocketConnector.this.processSessions(SocketConnector.this.selector.selectedKeys());
                        }
                        SocketConnector.this.processTimedOutSessions(SocketConnector.this.selector.keys());
                    } while (!SocketConnector.this.selector.keys().isEmpty());
                    SocketConnector socketConnector = SocketConnector.this;
                    synchronized (socketConnector) {
                        if (SocketConnector.this.selector.keys().isEmpty() && SocketConnector.this.connectQueue.isEmpty()) {
                            SocketConnector.this.worker = null;
                            try {
                                SocketConnector.this.selector.close();
                            }
                            catch (IOException e) {
                                SocketConnector.this.exceptionMonitor.exceptionCaught(SocketConnector.this, e);
                            }
                            finally {
                                SocketConnector.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException e) {
                    SocketConnector.this.exceptionMonitor.exceptionCaught(SocketConnector.this, e);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

