/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.codec;

import org.apache.mina.common.ByteBuffer;
import org.apache.mina.protocol.ProtocolDecoder;
import org.apache.mina.protocol.ProtocolDecoderOutput;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.ProtocolViolationException;

public abstract class CumulativeProtocolDecoder
implements ProtocolDecoder {
    private ByteBuffer buf;

    protected CumulativeProtocolDecoder(int defaultCapacity) {
        this.buf = ByteBuffer.allocate(defaultCapacity);
        this.buf.setAutoExpand(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(ProtocolSession session, ByteBuffer in, ProtocolDecoderOutput out) throws ProtocolViolationException {
        if (session.getTransportType().isStateless()) {
            throw new IllegalStateException("This decoder doesn't work for stateless transport types.");
        }
        ByteBuffer buf = this.buf;
        buf.put(in);
        buf.flip();
        try {
            do {
                int oldPos = buf.position();
                boolean decoded = this.doDecode(session, buf, out);
                if (!decoded) return;
                if (buf.position() != oldPos) continue;
                throw new IllegalStateException("doDecode() can't return true when buffer is not consumed.");
            } while (buf.hasRemaining());
            return;
        }
        finally {
            buf.compact();
        }
    }

    protected abstract boolean doDecode(ProtocolSession var1, ByteBuffer var2, ProtocolDecoderOutput var3) throws ProtocolViolationException;
}

