/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.protocol.filter;

import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.Session;
import org.apache.mina.protocol.ProtocolFilter;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.util.BaseThreadPool;
import org.apache.mina.util.EventType;
import org.apache.mina.util.ThreadPool;

public class ProtocolThreadPoolFilter
extends BaseThreadPool
implements ThreadPool,
ProtocolFilter {
    public void sessionOpened(ProtocolFilter.NextFilter nextFilter, ProtocolSession session) {
        this.fireEvent(nextFilter, session, EventType.OPENED, null);
    }

    public void sessionClosed(ProtocolFilter.NextFilter nextFilter, ProtocolSession session) {
        this.fireEvent(nextFilter, session, EventType.CLOSED, null);
    }

    public void sessionIdle(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, IdleStatus status) {
        this.fireEvent(nextFilter, session, EventType.IDLE, status);
    }

    public void exceptionCaught(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Throwable cause) {
        this.fireEvent(nextFilter, session, EventType.EXCEPTION, cause);
    }

    public void messageReceived(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
        this.fireEvent(nextFilter, session, EventType.RECEIVED, message);
    }

    public void messageSent(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
        this.fireEvent(nextFilter, session, EventType.SENT, message);
    }

    protected void processEvent(Object nextFilter0, Session session0, EventType type, Object data) {
        ProtocolFilter.NextFilter nextFilter = (ProtocolFilter.NextFilter)nextFilter0;
        ProtocolSession session = (ProtocolSession)session0;
        if (type == EventType.RECEIVED) {
            nextFilter.messageReceived(session, data);
        } else if (type == EventType.SENT) {
            nextFilter.messageSent(session, data);
        } else if (type == EventType.EXCEPTION) {
            nextFilter.exceptionCaught(session, (Throwable)data);
        } else if (type == EventType.IDLE) {
            nextFilter.sessionIdle(session, (IdleStatus)data);
        } else if (type == EventType.OPENED) {
            nextFilter.sessionOpened(session);
        } else if (type == EventType.CLOSED) {
            nextFilter.sessionClosed(session);
        }
    }

    public void filterWrite(ProtocolFilter.NextFilter nextFilter, ProtocolSession session, Object message) {
        nextFilter.filterWrite(session, message);
    }
}

