/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.examples.sumup;

import java.util.logging.Level;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.examples.sumup.message.AddMessage;
import org.apache.mina.examples.sumup.message.ResultMessage;
import org.apache.mina.protocol.ProtocolHandler;
import org.apache.mina.protocol.ProtocolSession;
import org.apache.mina.protocol.filter.ProtocolLoggingFilter;
import org.apache.mina.util.SessionLog;

public class ServerSessionHandler
implements ProtocolHandler {
    public void sessionCreated(ProtocolSession session) throws Exception {
        session.getFilterChain().addLast("logger", new ProtocolLoggingFilter());
    }

    public void sessionOpened(ProtocolSession session) {
        session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, 60);
        session.setAttachment(new Integer(0));
    }

    public void sessionClosed(ProtocolSession session) {
    }

    public void messageReceived(ProtocolSession session, Object message) {
        int value;
        AddMessage am = (AddMessage)message;
        int sum = (Integer)session.getAttachment();
        long expectedSum = (long)sum + (long)(value = am.getValue());
        if (expectedSum > Integer.MAX_VALUE || expectedSum < Integer.MIN_VALUE) {
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(false);
            session.write(rm);
        } else {
            sum = (int)expectedSum;
            session.setAttachment(new Integer(sum));
            ResultMessage rm = new ResultMessage();
            rm.setSequence(am.getSequence());
            rm.setOk(true);
            rm.setValue(sum);
            session.write(rm);
        }
    }

    public void messageSent(ProtocolSession session, Object message) {
    }

    public void sessionIdle(ProtocolSession session, IdleStatus status) {
        SessionLog.log(Level.WARNING, session, "Disconnecting the idle.");
        session.close();
    }

    public void exceptionCaught(ProtocolSession session, Throwable cause) {
        session.close();
    }
}

